;; Clase 20091020
;; (i) Clausuras, Estado y Objetos
;; (ii) Continuaciones en Scheme
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Clausuras
;; esta lambda se "cierra" sobre las varibles definidas en su scope lexico (el env en la creación de closureV)
(define counter
  (let ((x 0))
    (lambda()
      (set! x (+ 1 x))
      x)))

(counter) ; evalua a 1
(counter) ; que obtenemos?

;; creamos un "constructor" de contadores
;; cada uno guarda su propio valor de inicio
(define make-counter
  (lambda(x)
    (lambda()
      (set! x (+ 1 x))
      x)))

(define c1 (make-counter 0))
(c1)
(c1)
(define c2 (make-counter 10))
(c2)
(c1)

;; un "objeto" pair
;; tenemos un constructor de un pair [pair == (cons car cdr)]
;; la lambda interna recibe la llamada a sus "metodos"
;; los métodos tienen acceso a las "variables de instancia" [variables del scope léxico de definición]
(define make-pair
  (lambda(car cdr)
    (lambda(method)
      (cond
        ((eq? method 'car) car)
        ((eq? method 'cdr) cdr)
        (else "error")))))

(define mypair (make-pair 1 2))
(mypair 'car)
(mypair 'cdr)

;; dummy para nil
(define nil #f)

;; Propuesto: un mutable-pair
;; los métodos reciben 1 argumento [para car y cdr pasamos nil]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Continuaciones en Scheme
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; el nombre real de call/cc es call-with-current-continuation
; creamos un alias para hacer más fácil el código
(define call/cc call-with-current-continuation)

;; creamos una variable para guardar la continuación de la próxima invocación
(define captured-continuation nil)

;; sumamos 1 + (call/cc ...)
;; la continuación kont hace referencia al stack que aún falta por evaluar
;; En este caso, es como tener kont = (lambda(x)(+ 1 x))
(+ 1 (call/cc
      (lambda(kont)
        (set! captured-continuation kont)
        2)))

(captured-continuation 3)

;; otra forma equivalente:
;; nos aprovechamos de que kont es una función que recibe un parámetro
;; que es el valor de retorno desde el call/cc
(+ 1 (call/cc
      (lambda(kont)
        (set! captured-continuation kont)
        (kont 2))))

(captured-continuation 3)

;; y otra forma equivalente:
;; una vez invocada la continuación, se vuelve al stack original
;; Nunca se ejecutará el código que queda en (call/cc ...)
(+ 1 (call/cc
      (lambda(kont)
        (set! captured-continuation kont)
        (kont 2)
        24
        (display "nunca me imprimire :-("))))

(captured-continuation 3)

;; el código de (full-search sym tree) lo vemos completo la próxima clase...

