;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(planet plai/plai:1:3/lang/reader)
(define-type RCFAE/L
  [num (n number?)]
  [add (l RCFAE/L?)
       (r RCFAE/L?)]
  [sub (l RCFAE/L?)
       (r RCFAE/L?)]
  [times (l RCFAE/L?)
       (r RCFAE/L?)]
  [id (name symbol?)]
  [fun (param symbol?) (body RCFAE/L?)]
  [app (fun-expr RCFAE/L?) (arg-expr RCFAE/L?)]
  [if0 (test-case RCFAE/L?) (truth RCFAE/L?) (falsity RCFAE/L?)]
  [rec (bound-id symbol?) (fun-def RCFAE/L?) (bound-body RCFAE/L?)]
  )
                                   
; util para el parser, transformo un with n-ario, en multiples with simples
(define (parseNwith vars body)
  (if (null? vars) (parse body)
      (app (fun (first (first vars)) (parseNwith (cdr vars) body)) (parse (second (first vars))))))

; util para el parse, transformo un fun n-ario, en multiples fun simples
(define (parseNfun vars body)
  (if (null? vars) (parse body)
      (fun (first vars) (parseNfun (cdr vars) body))))

; util para el parse, transformo un app n-ario, en multiples app simples
(define (parseNapp function values)
  (if (null? values) (parse function)
      (app (parseNapp function (cdr values)) (parse (first values)))))

; debido como defini la construcción encadenada de app, debo entregar los valores invertidos, sino entro a un loop infinito (reevalúa la funcion con e mismo valor)
(define (invert list)
  (if (null? list) '()
      (append (invert (cdr list)) (cons (car list) '()))))


;; parse : sexp -> FAE
(define (parse sexp)
  (cond
    [(number? sexp) (num sexp)]
    [(list? sexp)
     (case (first sexp)
       [(+) (add (parse(second sexp))
                 (parse(third sexp)))]
       [(-) (sub (parse(second sexp))
                 (parse(third sexp)))]
       [(*) (times (parse(second sexp))
                 (parse(third sexp)))]  
       [(with) (parseNwith (second sexp) (third sexp))]
       [(rec) (rec (first (second sexp)) (parse (second (second sexp))) 
                (parse (third sexp))) ]
       [(fun) (parseNfun (second sexp) (third sexp))  ]
       [(if0) (if0 (parse (second sexp)) (parse (third sexp)) (parse (fourth sexp)))]
       [else (parseNapp (first sexp) (invert (cdr sexp)))]
       )]
    [(symbol? sexp) (id sexp)]
    ))

(define-type Env
  [mtSub]
  [aSub (name symbol?) (value RCFAE/L-Value?) (env Env?)]
  [aRecSub (name symbol?) (value boxed-RCFAE/L-Value?) (env Env?)]
  )

(define-type RCFAE/L-Value 
  [numV (n number?)]
  [closureV (param symbol?) (body RCFAE/L?) (env Env?)]
  [exprV (expr RCFAE/L?) (env Env?) (cache boxed-boolean/RCFAE/L-Value?)]
  )

(define (boxed-boolean/RCFAE/L-Value? v)
  (and (box? v)
       (or (boolean? (unbox v))
           (numV? (unbox v))
           (closureV? (unbox v)))))


(define (boxed-RCFAE/L-Value? v)
  (and (box? v) (RCFAE/L-Value? (unbox v))))

(define (strict e)
  (type-case RCFAE/L-Value e
             (exprV (expr env cache) (if (boolean? (unbox cache))
                                         (local [(define the-value (strict (interp expr env)))]
                                                (begin (set-box! cache the-value) the-value))
                                         (unbox cache)))
             (else e)))

(define (num-zero? v)
  (and (numV? v) (= 0 (numV-n (strict v)))))
  
(define (add-numbers l r)
      (numV (+ (numV-n (strict l)) (numV-n (strict r)))))

(define (sub-numbers l r)
      (numV (- (numV-n (strict l)) (numV-n (strict r)))))

(define (mult-numbers l r)
      (numV (* (numV-n (strict l)) (numV-n (strict r)))))

(define (lookup name env)
  (type-case Env env
             [mtSub () (error 'lookup 
                              (string-append "no binding for identifier: " (symbol->string name)))]
             [aSub (bound-name bound-value rest-env)
                   (if (symbol=? name bound-name)
                       bound-value
                       (lookup name rest-env))]
             [aRecSub (bound-name bound-value rest-env)
                   (if (symbol=? name bound-name)
                       (unbox bound-value)
                       (lookup name rest-env))]
             ))

(define (cyclically-bind-and-interp bound-id named-expr env)
  (local ([define value-holder (box (numV 850))]
          [define new-env (aRecSub bound-id value-holder env)]
          [define named-expr-val (exprV named-expr new-env (box false))])
          (begin (set-box! value-holder named-expr-val) new-env)))



(define (interp sexp env)
   (type-case RCFAE/L sexp
              [num (n) (numV n)]
              [add (l r) (add-numbers (interp l env) (interp r env))]
              [sub (l r) (sub-numbers (interp l env) (interp r env))]
              [times (l r) (mult-numbers (interp l env) (interp r env))]
              [id (v) (lookup v env)]
              [rec (bound-id named-expr bound-body)
                (interp bound-body 
                        (cyclically-bind-and-interp bound-id named-expr env))]
              [app (fun-expr arg-expr)
                   (local ([define fun-val (strict (interp fun-expr env))]
                           [define arg-val (exprV arg-expr env (box false))])
                     (interp (closureV-body fun-val) 
                             (aSub (closureV-param fun-val)
                                   arg-val (closureV-env fun-val))))
                     ]
              [fun (bound-id bound-body)
                   (closureV bound-id bound-body env)
                   ]
              [if0 (test-cause truth falsity) 
                   (if (num-zero? (strict (interp test-cause env)))
                       (interp truth env) (interp falsity env))]
              ))

(interp (parse '{with { {x 3} {y 5} {z x} }
                      {+ {+ y x} z}}) (mtSub))
(interp (parse '{{fun {x y} {+ x y}} 5 6}) (mtSub))
(interp (parse '{rec {fac {fun {n} 
                               {if0 n 1 {* n {fac {- n 1}}}}}}
                  {fac 5}}) (mtSub))
(interp (parse '{rec {sum {fun {t b} 
                               {if0 {- t b} 0 
                                          {+ t {sum  {- t 1} b}}}}}
                     {sum 5 3}}) (mtSub))

; laziness
(interp (parse '{with {{f {undex x}}} 4}) (mtSub))

