;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(planet plai/plai:1:3/lang/reader)
(define-type RCFAE
  [num (n number?)]
  [add (l RCFAE?)
       (r RCFAE?)]
  [sub (l RCFAE?)
       (r RCFAE?)]
  [times (l RCFAE?)
       (r RCFAE?)]
  [id (name symbol?)]
  [fun (param symbol?) (body RCFAE?)]
  [app (fun-expr RCFAE?) (arg-expr RCFAE?)]
  [if0 (test-case RCFAE?) (truth RCFAE?) (falsity RCFAE?)]
  [rec (bound-id symbol?) (fun-def RCFAE?) (bound-body RCFAE?)]
  )
                                   
; util para el parser, transformo un with n-ario, en multiples with simples
(define (parseNwith vars body)
  (if (null? vars) (parse body)
      (app (fun (first (first vars)) (parseNwith (cdr vars) body)) (parse (second (first vars))))))

; util para el parse, transformo un fun n-ario, en multiples fun simples
(define (parseNfun vars body)
  (if (null? vars) (parse body)
      (fun (first vars) (parseNfun (cdr vars) body))))

; util para el parse, transformo un app n-ario, en multiples app simples
(define (parseNapp function values)
  (if (null? values) (parse function)
      (app (parseNapp function (cdr values)) (parse (first values)))))

; debido como defini la construcción encadenada de app, debo entregar los valores invertidos, sino entro a un loop infinito (reevalúa la funcion con e mismo valor)
(define (invert list)
  (if (null? list) '()
      (append (invert (cdr list)) (cons (car list) '()))))


;; parse : sexp -> FAE
(define (parse sexp)
  (cond
    [(number? sexp) (num sexp)]
    [(list? sexp)
     (case (first sexp)
       [(+) (add (parse(second sexp))
                 (parse(third sexp)))]
       [(-) (sub (parse(second sexp))
                 (parse(third sexp)))]
       [(*) (times (parse(second sexp))
                 (parse(third sexp)))]  
       [(with) (parseNwith (second sexp) (third sexp))]
       [(rec) (rec (first (second sexp)) (parse (second (second sexp))) 
                (parse (third sexp))) ]
       [(fun) (parseNfun (second sexp) (third sexp))  ]
       [(if0) (if0 (parse (second sexp)) (parse (third sexp)) (parse (fourth sexp)))]
       [else (parseNapp (first sexp) (invert (cdr sexp)))]
       )]
    [(symbol? sexp) (id sexp)]
    ))

(define-type Env
  [mtSub]
  [aSub (name symbol?) (value RCFAE-Value?) (env Env?)]
  [aRecSub (name symbol?) (value boxed-RCFAE-Value?) (env Env?)]
  )

(define-type RCFAE-Value 
  [numV (n number?)]
  [closureV (param symbol?) (body RCFAE?) (env Env?)]
  )

(define (boxed-RCFAE-Value? v)
  (and (box? v) (RCFAE-Value? (unbox v))))

(define (num-zero? v)
  (and (numV? v) (= 0 (numV-n v))))
  
(define (add-numbers l r)
  (if (and (numV? l) (numV? r))
      (numV (+ (numV-n l) (numV-n r)))
      (error "Suma de no numeros")))

(define (sub-numbers l r)
  (if (and (numV? l) (numV? r))
      (numV (- (numV-n l) (numV-n r)))
      (error "Suma de no numeros")))

(define (mult-numbers l r)
  (if (and (numV? l) (numV? r))
      (numV (* (numV-n l) (numV-n r)))
      (error "Multiplicación de no numeros")))

(define (lookup name env)
  (type-case Env env
             [mtSub () (error 'lookup 
                              (string-append "no binding for identifier: " (symbol->string name)))]
             [aSub (bound-name bound-value rest-env)
                   (if (symbol=? name bound-name)
                       bound-value
                       (lookup name rest-env))]
             [aRecSub (bound-name bound-value rest-env)
                   (if (symbol=? name bound-name)
                       (unbox bound-value)
                       (lookup name rest-env))]
             ))

(define (cyclically-bind-and-interp bound-id named-expr env)
  (local ([define value-holder (box (numV 850))]
          [define new-env (aRecSub bound-id value-holder env)]
          [define named-expr-val (interp named-expr new-env)])
          (begin (set-box! value-holder named-expr-val) new-env)))

(define (interp sexp env)
   (type-case RCFAE sexp
              [num (n) (numV n)]
              [add (l r) (add-numbers (interp l env) (interp r env))]
              [sub (l r) (sub-numbers (interp l env) (interp r env))]
              [times (l r) (mult-numbers (interp l env) (interp r env))]
              [id (v) (lookup v env)]
              [rec (bound-id named-expr bound-body)
                (interp bound-body 
                        (cyclically-bind-and-interp bound-id named-expr env))]
              [app (fun-expr arg-expr)
                   (local ([define fun-val (interp fun-expr env)])
                     (interp (closureV-body fun-val) 
                             (aSub (closureV-param fun-val)
                                   (interp arg-expr env)  (closureV-env fun-val))))
                     ]
              [fun (bound-id bound-body)
                   (closureV bound-id bound-body env)
                   ]
              [if0 (test-cause truth falsity) 
                   (if (num-zero? (interp test-cause env))
                       (interp truth env) (interp falsity env))]
              ))

(interp (parse '{with { {x 3} {y 5} {z x} } {+ {+ y x} z}}) (mtSub))
(interp (parse '{{fun {x y} {+ x y}} 5 6}) (mtSub))
(interp (parse '{rec {fac {fun {n} {if0 n 1 {* n {fac {- n 1}}}}}} {fac 5}}) (mtSub))
(interp (parse '{rec {sum {fun {t b} {if0 {- t b} 0 {+ t {sum  {- t 1} b}}}}}
                     {sum 5 3}}) (mtSub))

