;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(planet plai/plai:1:3/lang/reader)
;; Definici'on de la gram'atica de lambda-c'alculo
(define-type Expr
  (num (n number?))
  (id  (var symbol?))
  (add (left Expr?) (right Expr?))
  (ifc (condition Expr?) (body-then Expr?) (body-else Expr?))
  (fun (arg symbol?) (body Expr?))
  (app (fx Expr?) (param Expr?)))

;; parse:: sList -> Expr
(define (parse sexp)
  (cond
    [(number? sexp) (num sexp)]
    [(symbol? sexp) (id sexp)]
    [(list? sexp)
     (case (first sexp)
       [(+) (add (parse(second sexp))
                 (parse(third sexp)))]
       [(if) (ifc (parse (second sexp)) (parse (third sexp)) (parse (fourth sexp)))]
       [(lambda) (fun (first (second sexp)) (parse (third sexp)))]
       [else (app (parse (first sexp)) (parse (second sexp)))])]))

;;list->set::List-of(symbol) -> List-of(symbol)
;;Recibe un multiconjunto y devuelve su conjunto
(define (list->set ls)
  (if (empty? ls) '() 
      (cons (first ls) (list->set (remove* (list (first ls)) ls)))))


;; free-vars:: Expr -> list-of(symbol)
;; Devuelve la lista de variables libres (sin repetidos)
(define (free-vars expr) (list->set (free-vars* expr)))

;; free-vars*:: Expr -> list-of(symbol)
;; Devuelve la lista de variables libres (con repetidos)
;; obtener lista de variables libres (con repetidos)
(define (free-vars* expr)
  (type-case Expr expr
             (num (n) empty)
             (id (v) (list v))
             (add (l r) (append (free-vars* l) (free-vars* r)))
             (ifc (c bt be) (append (free-vars* c) (free-vars* bt) (free-vars* be)))
             (app (f a) (append (free-vars* f) (free-vars* a)))
             (fun (a b) (remove* (list a) (free-vars* b)))
             ))

;; Variables libres
(test (free-vars (parse '{+ a b})) '(a b))
;; Variables no libre (ligadas)
(test (free-vars (parse '{lambda {x}
                              {+ x x}})) 
      '())
;; Variables fuera del scope
(test (free-vars (parse '{{lambda {x} {lambda {y} {+ x y}}} 
                          {if x x x}}))
      '(x))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define lista-pares
  (letrec 
      ((lista '())
       (pares (lambda (n)
                (if (eq? n 0) lista
                    (begin
                      (set! lista (cons (* n 2) lista))
                      (pares (- n 1)))))))
     pares))

(test (lista-pares 3) '(2 4 6))
(test (lista-pares 3) '(2 4 6)) ;; Bad
(test (lista-pares 1) '(2 2 4 6 2 4 6))

;; 0,1 contrato
;; lista-pares* :: number -> list-of(number)
(define (lista-pares* n) 
  (reverse (lista-pares-acc n '()))) ;; 0,2 usar reverse y llamar a función auxiliar.

;; 0,1 contrato
;; 0,6 implementación
;; lista-pares-acc :: number x list-of(number) -> list-of(number)
(define (lista-pares-acc n ls-acc)
  (if (eq? n 0) ls-acc
      (cons (* n 2) (lista-pares-acc (- n 1) ls-acc))))

(test (lista-pares* 3) '(2 4 6))
(test (lista-pares* 3) '(2 4 6))
(test (lista-pares* 1) '(2))