;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(planet plai/plai:1:3/lang/reader)
;; Clase Auxiliar CC41A
;; Consultas a:
;; Victor Ramiro - <vramiro@dcc.uchile.cl>

;; API Arbol
(define (empty-tree) '())
(define (make-tree val left rigth) (list val left rigth))
(define (value tree) (car tree))
(define (left tree) (car (cdr tree)))
(define (rigth tree) (car (cdr (cdr tree))))
(define (leave? tree) 
  (and (null? (left tree)) (null? (rigth tree))))

(define arbol (make-tree 1 (make-tree 2 '() '()) (make-tree 3 '() '())))
arbol

;; P1
(define (make-bintree-n ls)
  (letrec ((make (lambda (lst tree)
                (if (null? lst) tree
                    (make (cdr lst) (make-bintree-1 (car lst) tree)))))) 
    (make ls '()))
  )

;; make-bintree-1:: Symbol, BinTree -> BinTree
(define (make-bintree-1 a bt)
  (cond
    ((null? bt) (make-tree a (empty-tree) (empty-tree)))
    ((< a (value bt)) (make-tree (value bt) (make-bintree-1 a (left bt)) (rigth bt)))
    (else (list (value bt) (left bt) (make-bintree-1 a (rigth bt))))
    ))

(define tree-from-list (make-bintree-n '(3 2 4 1 5)))
tree-from-list

;; P2
(define (map-tree tree f)
  (cond
    ((null? tree) (empty-tree))
    (else  (make-tree (f (value tree)) (map-tree (left tree) f) (map-tree (rigth tree) f)))))

(map-tree tree-from-list (lambda(x) (* 2 x)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; P3
(define compose 
  (lambda (f g) 
    (lambda (x) 
      (f (g x))))) 

((compose (lambda (x) (* x x)) (lambda (x) (+ 1 x))) 7) 

;; P4
(define repeated 
  (lambda (f n) 
    (if (= n 1) f 
        (compose f (repeated f (- n 1)))))) 


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; P5
;;
;Substitución: To substitute identifier i in e with expression v, replace all non-binding 
;identiﬁers in e having the name i with the expression v, except within nested scopes of i. 

;Substitución: To substitute identifier i in e with expression v, replace all free instances 
;of i in e with v. 

; Bound instance: An identifier is bound if it is contained within the scope of a binding in- 
;stance of its name. 

;Scope: The scope of a binding instance is the region of program text in which instances of the 
;identifier refer to the value bound by the binding instance. 


;; Scope estático: In a language with static scope, the scope of an identifier’s binding is a 
; syntactically delimited region. 

;; Scope dinámico: In a language with dynamic scope, the scope of an identifier’s binding is 
; the entire remainder of the execution during which that binding is in effect.

;; Scope dinámico:

;(define (f p) n)
;(local ([define n 5]) 
;(f 10)) 



;;;;;;;;;;;;;;;;;;;;;;;
;; P6
;;
;{with {x {+ 3 4}}
;  {with {y {seq {print x} 
;                {+ x 1}}}
;      {+ y y}}}
;
;Pauta:
;1. Evaluación: {+ 3 4} resultado: 7
;2. Subtitución: 'x por: 7 en: {print x}
;3. Estado de Pantalla: 7
;4. Subtitución: 'x por: 7 en: {+ x 1}
;5. Evaluación: {+ 7 1} resultado: 8
;6. Subtitución: 'y por: 8 en: {+ y y}
;7. Evaluación: {+ 8 8} resultado: 16
;
;Pauta:
;1.  Subtitución: 'y por: {seq {print x} {+  x 1}} en: {+ y y}
;--  1ra occurrencia de 'y en {+ y y}
;2.  Subtitución: 'x por: {+ 3 4} en: {print x}
;3.  Evaluación: {+ 3 4} resultado: 7
;4.  Subtitución de Pantalla: 7
;5.  Subtitución: 'x por: {+ 3 4} en: {+ x 1}
;6.  Evaluación: {+ {+ 3 4} 1} resultado: 8
;--  2da occurrencia de 'y en {+ y y}
;7.  Subtitución: 'x por: {+ 3 4} en: {print x}
;8.  Evaluación: {+ 3 4} resultado: 7
;9.  Estado de Pantalla: 7 7
;10. Subtitución: 'x por: {+ 3 4} en: {+ x 1}
;11. Evaluación: {+ {+ 3 4} 1} resultado: 8
;12. Evaluación: {+ 8 8} resultado: 16
;
;¿son equivalentes ambos régimenes? ¿por qué?: 
;Ambos régimenes no son equivalentes apesar de retornar el
;mismo resultado. Esto se debe, en el ejemplo, a la diferencia en el estado de pantalla. La
;subtitución eager imprimirá una sola vez el valor de 7, mientras que la
;subtitución lazy lo imprimirá dos veces.

