;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(planet plai/plai:1:3/lang/reader)
(require (planet plai/plai:1:3)) 

(define-type F
  (num (n number?))
  (add (l F?)(r F?))
  (sub (l F?)(r F?))
  (times (l F?)(r F?))
  (id (name symbol?))
  (with (id symbol?) (sexpr F?) (body F?))
  (app (fun symbol?) (arg F?))
  (if0 (test F?) (true F?) (false F?)))

(define-type FUN
  (fun (name symbol?) (arg symbol?) (body F?)))

;; auxiliary functions
(define (debug exp)
  (if #t
      (begin
        (display "[DEBUG]:")
        (display exp)
        (newline))
      '()))

(define (drop-empty list) 
  (lfilter (lambda(x) (not (null? x))) list))

(define (lfilter p l)
  (cond
    ((null? l) '())
    ((p (car l)) (cons (car l) (filter p (cdr l))))
    (else (filter p (cdr l)))))

(define (repeated-ids lop)
  (letrec ((list-ids (lambda(l)
                       (if (null? l) '()
                           (cons (caar l) (list-ids (cdr l))))))
           (iter (lambda(l)
                   (if (null? l) #f
                       (or (not (= 0 (length (lfilter (lambda(x)(symbol=? x (car l))) (cdr l)))))
                           (iter (cdr l)))))))
    (iter (list-ids lop))))

;; external functions environment
(define fun-env '())

(define (fun-add fundef)
  (set! fun-env (cons fundef fun-env)) '())

(define (lookup fname list)
  (if (null? list) (error "Function not found")
      (if (symbol=? fname (fun-name (car list)))
          (car list)
          (lookup fname (cdr list)))))

;; from code -> AST
(define (parse sexp)
  ;(debug sexp)
  (cond 
    ((number? sexp) (num sexp))
    ((symbol? sexp) (id sexp))
    ((null? sexp) '())
    ((list? sexp)
     (let ((op (first sexp)))
       (cond
         ((list? (car sexp)) (cons (parse (car sexp)) (parse (cdr sexp))))
         ((symbol=? op '+) (add (parse (cadr sexp)) 
                                (parse  (caddr sexp))))
         ((symbol=? op '-) (sub (parse (cadr sexp)) 
                                (parse  (caddr sexp))))
         ((symbol=? op '*) (times (parse (cadr sexp)) 
                                  (parse  (caddr sexp))))
         ((symbol=? op 'if0) (if0 (parse (cadr sexp))
                                  (parse (caddr sexp))
                                  (parse (cadddr sexp))))
         ((symbol=? op 'with) (with (car (cadr sexp)) 
                                    (parse (cadr (cadr sexp))) 
                                    (parse (caddr sexp))))
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ((symbol=? op 'mwith) (let ((wdefs (second sexp))
                                     (body (third sexp)))
                                 (if (repeated-ids wdefs)
                                     (error "Parser error, repeated ids in with definition")
                                     (if (not (null? (cdr wdefs)))
                                         (with (first (first wdefs))
                                               (parse (second (first wdefs)))
                                               (parse (list 'mwith (rest wdefs) body)))
                                         (with (first (first wdefs))
                                               (parse (second (first wdefs)))
                                               (parse body))))))
         ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
         ((symbol=? op 'defun) (fun-add (fun (car (cadr sexp)) 
                                             (cadr (cadr sexp)) 
                                             (parse (caddr sexp)))))
         ((symbol? op) (app (car sexp) 
                            (parse (cadr sexp)))))))))

;; from AST -> AST
(define (subst wid val expr)
  (type-case F expr
             (num (n) expr)
             (add (l r) (add (subst wid val l) (subst wid val r)))
             (sub (l r) (sub (subst wid val l) (subst wid val r)))
             (times (l r) (times (subst wid val l) (subst wid val r)))
             (if0 (test true false)
                  (if0 (subst wid val test)
                       (subst wid val true)
                       (subst wid val false)))
             (with (id sexpr body)
                   (if (symbol=? wid id)
                       (with id
                             (subst wid val sexpr)
                             body)
                       (with id 
                             (subst wid val sexpr)
                             (subst wid val body))))
             (app (fun arg) (app fun
                                 (subst wid val arg)))
             (id (name) 
                 (if (symbol=? wid name)
                     val
                     expr))))

;; from AST -> value
(define (interp expr fenv)
  ;(debug expr)
  (type-case F expr
             (num (n) n)
             (add (l r) (+ (interp l fenv) (interp r fenv)))
             (sub (l r) (- (interp l fenv) (interp r fenv)))
             (times (l r) (* (interp l fenv) (interp r fenv)))
             (if0 (test true false) (if (= (interp test fenv) 0)
                                        (interp true fenv)
                                        (interp false fenv)))
             (with (wid sexpr body) 
                   (interp (subst wid 
                                  (num (interp sexpr fenv))
                                  body)
                           fenv))
             (app (fname arg)
                  (let ( (fun (lookup fname fenv)))
                    (interp (subst (fun-arg fun)
                                   (num (interp arg fenv))
                                   (fun-body fun))
                            fenv)))
             (id (name) (error "Free var"))))

;; interp a list of AST's
(define (interp-each l t)
 (cond 
   ((null? l) '())
   (else 
    (let ((value (interp (car l) fun-env)))
      (begin
        (display value)
        (newline)
        (test value (car t))
        (interp-each (cdr l) (cdr t)))))))

;; Test
(define code '{
               {defun {mas2 x} {+ x 2}}
               {defun {mas4 x} {+ x {mas2 {mas2 0}}}}
               {defun {fac x}{if0 x 
                                  1
                                  {* x {fac {- x 1}}}}}
               {with {x 10}{+ {mas2 {+ 1 1}} x}}
               {with {x 40}{+ {mas2 0} {mas4 0}}}
               {with {x 10}{with {y x} {+ y y}}}
               {with {x 5}{+ x {with {y 3} x}}}
               {with {x 5}{with {y x} y}}
               {with {x 5}{with {x x} x}}
               {with {x 5}{+ x {with {x 3} x}}}
               {with {x {+ 1 1}} {+ x x}}
               {if0 {+ -1 1}{mas2 2}{+ 1 2}}
               {with {x 0}{if0 x 1 2}}
               {- 1 1}
               {* 2 4}
               {fac 5}
               {with {x 5}{fac x}}
               {mwith {{x 1} {y 2} {z {+ x y}}} {+ x {* y z}}}
               })

(define ast (parse code))
ast
fun-env
(interp-each (drop-empty ast) '(14 6 20 10 5 5 8 4 4 1 0 8 120 120 7))

;; parser error
;(parse '{mwith {{x 1} {y 2} {x 3}} x})
