;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(planet plai/plai:1:3/lang/reader)
(define-type DefrSub
  [mtSub]
  [aSub (name symbol?) (value number?) (ds DefrSub?)]
  )

(define (lookup name ds)
  (type-case DefrSub ds
             [mtSub () (error 'lookup "no binding for identifier")]
             [aSub (bound-name bound-value rest-ds)
                   (if (symbol=? name bound-name)
                       bound-value
                       (lookup name rest-ds))]))

;; Version mala, scope dinámica
(define (interp sexp fun-defs ds)
  (type-case F1WAE sexp
              [num (n) n]
              [add (l r) (+ (interp l fun-defs ds) (interp r fun-defs ds))]
              [sub (l r) (- (interp l fun-defs ds) (interp r fun-defs ds))]
              [with (bound-id named-expr bound-body)
                    (interp bound-body fun-defs (aSub bound-id 
                                                      (interp named-expr fun-defs ds) ds))]
              [app (fun-name arg-expr)
                   (local ([define the-fun-def (lookup-fundef fun-name fun-defs)])
                     (interp  (fundef-body the-fun-def)
                              fun-defs
                              (aSub (fundef-arg-name the-fun-def)
                                    (interp arg-expr fun-defs ds)
                                    ds)))]
              [id(v) (lookup v ds)]))

;; Version OK, scope estático
(define (interp sexp fun-defs ds)
  (type-case F1WAE sexp
              [num (n) n]
              [add (l r) (+ (interp l fun-defs ds) (interp r fun-defs ds))]
              [sub (l r) (- (interp l fun-defs ds) (interp r fun-defs ds))]
              [with (bound-id named-expr bound-body)
                    (interp bound-body fun-defs 
                            (aSub bound-id 
                               (interp named-expr fun-defs ds) ds))]
              [app (fun-name arg-expr)
                   (local ([define the-fun-def (lookup-fundef fun-name fun-defs)])
                     (interp  (fundef-body the-fun-def)
                              fun-defs
                              (aSub (fundef-arg-name the-fun-def)
                                    (interp arg-expr fun-defs ds)
                                    (mtSub)
                                    )))]
              [id(v) (lookup v ds)]))
