(define-type WAE 
  [num (n number?)]
  [add (lhs WAE?) (rhs WAE?)]
  [sub (lhs WAE?) (rhs WAE?)]
  [with (id-ref symbol?) (val WAE?) (body WAE?)]
  [id (v symbol?)]
  )

(define (parse sexp)
  (cond 
    [(number? sexp) (num sexp)]
    [(list? sexp) 
     (case (first sexp)
       [(+)(add (parse (second sexp)) (parse (third sexp)))]
       [(-)(sub (parse (second sexp)) (parse (third sexp)))]
       [(with) (with (first (second sexp)) 
               (parse (second (second sexp))) 
               (parse (third sexp)))]
       )
       ]
    [(symbol? sexp) (id sexp)]
    ))

(define (subst expr bound-id val)
  (type-case WAE expr
             [num (n) expr]
             [add (l r) (add (subst l bound-id val) (subst r bound-id val) )]
             [sub (l r) (sub (subst l bound-id val) (subst r bound-id val) )]
             [with (sub-id sub-expr sub-body) 
                   (if (symbol=? sub-id bound-id)
                       expr
                       (with sub-id sub-expr (subst sub-body bound-id val)))]
             [id (v) (if (symbol=? v bound-id) val expr)]
             ))
  

