(define-type AE 
  [num (n number?)]
  [add (lhs AE?) (rhs AE?)]
  [sub (lhs AE?) (rhs AE?)]
  )

(define (parse sexp)
  (cond 
    [(number? sexp) (num sexp)]
    [(list? sexp) 
     (case (first sexp)
       [(+)(add (parse (second sexp)) (parse (third sexp)))]
       [(-)(sub (parse (second sexp)) (parse (third sexp)))]
       )
       ]
    ))

(define (calc sexpr)
  (type-case AE sexpr
             [num (n) n]
             [add (l r) (+ (calc l) (calc r))]
             [sub (l r) (- (calc l) (calc r))]))
