package relosdigital;

import relosdigital.logica.Normal;
import relosdigital.logica.EstadoReloj;
import relosdigital.componentes.Boton;
import relosdigital.tiempo.Tiempo;

/**
 *
 * El reloj para la clase aux de cc3002, prim 2009
 *
 *
 * @author carlos
 */
public class Reloj extends Observer {

    protected EstadoReloj estadoActual;
    protected Boton botonA;
    protected Boton botonB;
    protected Tiempo tiempo;

    public Reloj() {

        this.estadoActual = new Normal();
        this.tiempo = new Tiempo();

        this.botonA = new Boton();
        this.botonB = new Boton();

        this.botonA.agregar(this);
        this.botonB.agregar(this);

    }

    @Override
    void notificar(Subject unSubject) {

        //El comportamiento depende del estado, asi que le pasamos el boton al estado
        this.estadoActual.accion(unSubject, this);

        System.out.println(tiempo); //solo para mostrar que cambia: no hay pantalla ni mecanismo para que el tiempo avance solo

    }


    //atajos para apretar botones
    public void apretarBotonA() {

        this.botonA.apretar();

    }

    public void apretarBotonB() {

        this.botonB.apretar();

    }


    //getters/setters
    public EstadoReloj getEstadoActual() {
        return estadoActual;
    }

    public Tiempo getTiempo() {
        return tiempo;
    }

    public void setEstadoActual(EstadoReloj estadoActual) {
        this.estadoActual = estadoActual;
    }

    public Boton getBotonA() {
        return botonA;
    }

    public Boton getBotonB() {
        return botonB;
    }
}
