
public class HeapMin{
	private Comparable[] a;
	private int actual;
		
	public HeapMin(int max){
		a=new Comparable[max];
		actual=0;
	}
		
	public Comparable getMin()throws Exception{
		if(actual<1){
			throw new Exception();
		}
		Comparable r=a[0]; // guardamos el que esta en la punta
		swap(0,--actual); // ponemos el ultimo en la punta
		bajar(0); // bajamos al que pusimos en la punta a la posisicon que le corresponde
		return r;
	}
	
	public void addElement(Comparable e)throws Exception{
		if(actual==a.length){
			throw new Exception();
		}
		a[actual++]=e; // lo colocamos en el ultimo lugar
		subir(actual-1); // lo subimos hasta donde corresponda
	}
	
	public void subir(int posicion){
		if(posicion!=0){ // si no estamos en la raiz
			int padre=(int)Math.floor((posicion+1)/2)-1;
			if(a[posicion].compareTo(a[padre])<0){ // si el hijo es menor los cambiamos
				swap(posicion,padre);
				subir(padre); // recursivamente seguimos subiendo
			}
		}
	}
	
	public void bajar(int posicion){
		int[] hijos={2*posicion+1,2*(posicion+1)};
		if(hijos[0]>=actual){ // ambos fuera del rango del heap
			return;
		}
		if(hijos[1]>=actual){ // hijo 0 es el ultimo
			if(a[hijos[0]].compareTo(a[posicion])<0){
				swap(posicion,hijos[0]); // cambiamos y no llamamos recursivamente, pues es el ultimo   
			}
		}// hay que comparar ambos hijos
		if(a[hijos[0]].compareTo(a[posicion])<0 && a[hijos[1]].compareTo(a[posicion])<0){ // ambos hijos menores
			if(a[hijos[0]].compareTo(a[hijos[1]])<0){ // hijo 0 menor cambiamos con ese
				swap(hijos[0],posicion);
				bajar(hijos[0]);
			}else{ // sino cambiamos con el hijo 1
				swap(hijos[1],posicion);
				bajar(hijos[1]);
			}
		}else if(a[hijos[0]].compareTo(a[posicion])<0){ // solo el hijo 0 es menor
			swap(hijos[0],posicion);
			bajar(hijos[0]);
		}else if(a[hijos[1]].compareTo(a[posicion])<0){ // solo el hijo 1 es menor
			swap(hijos[1],posicion);
			bajar(hijos[1]);
		}
	}
	
	private void swap(int i,int j){
		Comparable t=a[i];
		a[i]=a[j];
		a[j]=t;
	}
}
