mode(1)
clc
//This script is based on Chapter 1 of the textbook
//"Numerical and Statistical Methods with SCILAB for Science and Engineering"
// type 'enter' after each 'halt()' 
// command to continue with the scritp execution

halt(); clc;
//Getting started with SCILAB
//Loading a value into a variable
a = 3.2 
halt(); clc;

b = 6.4 
halt(); clc;

a+b     //addition
halt(); clc;

a-b     //subtraction  
halt(); clc;

a*b     //multiplication
halt(); clc;

  
a/b     //division
halt(); clc;


a^b     //raising to a power
halt(); clc;

  
who     //command to list all active variables
halt(); clc;


//SCILAB constants - predefined values
%e     //e = base of natural logarithms
halt(); clc;


%i     //i = unit imaginary number
halt(); clc;


%pi    //pi = ratio of circumference length to its diameter
halt(); clc;


%eps   //epsilon = small constant for rounding down numbers to zero
halt(); clc;


%inf   //infinity
halt(); clc;


%nan   //not-a-number
halt(); clc;


%t     //logical value = true
halt(); clc;


%f     //logical value = false
halt(); clc;



//Simple operations with scalars
a =2    //loading values
b =3 
halt(); clc;


save a   //Save variable to binary file
halt(); clc;


clear a  //Clear name 'a' from memory
who      //check that a is not in memory
halt(); clc;


load a   //load value 'a' back into memory
a        //check that value of a was recovered
halt(); clc;


//Try vector operations in page 6 on your own
halt(); clc;


//Entering matrices
A = [1. 2. 3.; 4. 5. 6.; 1. -1. 0.] 
halt(); clc;


B = [ 1. 1. 1. 
2. 3. -1. 
5. 7. -2. ] 
halt(); clc;


//Entering some vectors (no output by using ;)
u = [1. 3. -5. ]; v = [4. 2. 3. ]; w = [-1. 0. 1.]; 
halt(); clc;


//Creating matrices and vectors
C = [u; v; w]  //vectors are rows of C
halt(); clc;


r = [u, v, w]  //creating a single vector
halt(); clc;


D = [u' v' w'] //transpose vectors are rows of D
halt(); clc;


//Matrix operations
A + B          //addition
halt(); clc;


C - D          //subtraction
halt(); clc;


A*B            //matrix multiplication
halt(); clc;

 
B*A
halt(); clc;
 
D*v'
halt(); clc;
 
rank (A)      //rank function
halt(); clc;
 
inv(A)        //inverse function
halt(); clc;
 
cond(B)       //condition number
halt(); clc;
 
det(C)        //determinant of matrix
halt(); clc;
 
A*inv(A)      //verify identity matrix
halt(); clc;
 
inv(B)*B      
halt(); clc;
 
spec(A)    //calculates eigenvalues
halt(); clc;

trace(C)   //trace 

//Solution of linear systems:
A = [1. 3. 2.; 2. 1. -1.; 5. 2. 1.]; b = [2; 3; 4]; 
halt(); clc;

xa = inv(A)*b       //Using the inverse
halt(); clc;

xb = linsolve(A,b)  //Using function 'linsolve'
halt(); clc;

//Try exercises in pages 7-12 for input-output, diary files, etc.
halt(); clc;

//end of script
mode(0)
