clear
program drop _all
set mem 500m
cd "C:\stata\in540"

/*recuerden que deben crear una carpeta en C:\*/
/*con el nombre stata\in540 y cargar las bases ah*/

/*usamos los mismos datos de la auxiliar 1*/
use datosaux1, clear

/*describe los datos*/
desc

/*realiza un resumen de las variables que se escribes*/
sum wage iq educ exper tenure age married black south urban sibs brthord meduc feduc 

/*matriz de correlacin*/
pwcorr wage iq educ exper tenure age married black south urban sibs brthord meduc feduc, star(.05) 

/*PARTE1*/

/*(A)*/
	/*generar variables de inters*/
 	gen lwage=ln(wage)
	gen s_exp=exper^2

	/*realizar la regresin */
	reg lwage educ exper s_exp tenure age

	/* para cambiar el intervalo de confianza a 99% por ejemplo, que viene por default */
	/* en 95%: set level 99 , pero esto es solo para analizar los intervalos de confianza, */
	/* y no tiene nada que ver con el % de significatividad individual de cada variable. */

	/*otra forma de ver la significatividad individual*/
	test educ=0
	test exper=0
	test s_exp=0
	test tenure=0
	test age=0
	test _cons=0


	/*varianza estimada de los errores*/
	predict reg_err, residuals
	gen reg_err2=reg_err*reg_err
	gen sum_reg_err2=sum(reg_err2)
	display sum_reg_err2[935]
	local var_err=sum_reg_err2[935]/(935-6)
	display var_err

	/*matriz de varianza-covarianza*/
	estat vce
	

/*(B)*/

	/*significatividad conjunta*/
	test educ=0
	test exper=0, accu
	test s_exp=0, accu
	test tenure=0, accu
	test age=0, accu

	/*o bien*/
	test (educ=0) (exper=0) (s_exp=0) (tenure=0) (age=0)

	/*o bien*/
	test educ= exper= s_exp= tenure= age=0
	

/*PARTE2*/

/*(A)*/
	/*realizar la regresin para intervalo de confianza de 95%*/
	reg lwage educ exper tenure age

	/*test Ho: efecto de exper es igual al efecto de tenure*/
	test exper=tenure
