import java.io.*;

public class programa {
    
    public static void main(String[] arg) throws Exception
    {
       //parte 1
       String polaca=U.readLine("Ingrese formula en notacin polaca");
       String infijo=toInfixNotation(polaca);
       U.println("En notacin de infijo queda: "+infijo);
       
       
       //parte 2       
       Tabla datos=buildTabla("datos.txt");
       TreeNode t=buildTree(polaca);
       double valor=evaluar(t,datos);
       
       U.println("El valor de la expresin es: "+valor);
    }
    
    public static TreeNode buildTree(String in) throws Exception
    {
    	//se construye un rbol que represente la frmula
        //mediante la ayuda de una pila
    	
        StackNode stack=new StackNode();
        
        //aqu se guardan los nombres de variables vlidos.
        String abc=abc();
        
        //recorremos el String
        for (int i=0;i<in.length();i++)
        {
            char c=in.charAt(i);
            
            if ("+-*/".indexOf(c)==-1) // si es una variable
            {
            	if (abc.indexOf(c)==-1)
                    throw new Exception("'"+c+"' es un nombre de variable invlido");
            	
                //si es un nombre de variable vlido
            	stack.push(new TreeNode(c+""));
            }
            else
            {
            	//si se trata de un operador
                Object lt=stack.pop(),rt=stack.pop();
                
                if (lt==null || rt==null)
                    throw new Exception("demasiados operadores");
                
                TreeNode a=(TreeNode)lt;
                TreeNode b=(TreeNode)rt;
                TreeNode t=new TreeNode(c+"",b,a);
                
                stack.push(t);
            }
        }
        
        Object ft=stack.pop();
        //corresponde al rbol final.
        
        if (ft==null)
            throw new Exception("demasiados operadores");
        
        if (!stack.empty())
            throw new Exception("faltan operadores");
        
        return (TreeNode)ft;
    }
    
    public static String toInfixNotation(String in) throws Exception{
        return buildTree(in).toString();
    }
    
    public static String abc()
    {
        String s="";
        for (char i='a';i<='z';i++)
            s+=i;
        for (char i='A';i<='Z';i++)
            s+=i;
        s+="";
        
        return s;
    }       

    public static Tabla buildTabla(String file) throws Exception{
    	BufferedReader bf=new BufferedReader(new FileReader(file));
    	
    	Tabla t=new Tabla(100);
    	String linea;
    	
    	while ((linea=bf.readLine())!=null){
    		char var=linea.charAt(0);
    		double value=Double.parseDouble(linea.substring(1));
    		t.agregar(var,value);
    	}
    	
    	return t;
    }
    
    public static double evaluar(TreeNode t,Tabla datos) throws NoExiste{
    	
    	//caso default
		if(t==null)
		return 0;
		
		char c=((String)t.object).charAt(0);
		
		//si es una hoja, almacena el valor numrico
		if(t.left==null && t.right==null){
			return datos.valueOf(c);
		}
		
		//sino es hoja, entonces es una operacin
		if (c=='+')
			return evaluar(t.left,datos)+evaluar(t.right,datos);
		if (c=='-')
			return evaluar(t.left,datos)-evaluar(t.right,datos);
		if (c=='*')
			return evaluar(t.left,datos)*evaluar(t.right,datos);
		//if (c=='/')
			return evaluar(t.left,datos)/evaluar(t.right,datos);
    }
}