
public class Vector{
	protected double[] x;
	protected int n;
	
	public Vector(int n){
		x=new double[n];
		
		this.n=n;
		
		for (int i=0;i<n;i++)
			x[i]=0;
	}
	
	public int dim(){
		return n;
	}
	
	public void set(double d,int i){
		x[i]=d;
	}
	
	public double get(int i){
		return x[i];
	}
	
	public Vector ponderar(double a){
		
		Vector v=new Vector(n);
		
		for (int i=0;i<n;i++)
			v.set(a*this.get(i) ,i);
		
		return v;
	}
	
	public Vector sumar(Vector v){
		if (this.dim()!=v.dim())
			return null;
		
		Vector r=new Vector(n);
		
		for (int i=0;i<n;i++)
			r.set(this.get(i)+v.get(i) ,i);
		
		return r;
	}
	
	public Vector restar(Vector v){
		return this.sumar(v.ponderar(-1));
	}
	
	/*
	public Vector restar(Vector v){
		if (this.dim()!=v.dim())
			return null;
		
		Vector r=new Vector(n);
		
		for (int i=0;i<n;i++)
			r.set(this.get(i)-v.get(i) ,i);
		
		return r;
	}
	*/
	
	public double norma(){
		double s=0;
		for (int i=0;i<n;i++)
			s+=x[i]*x[i];
		
		return Math.sqrt(s);
	}
	
	public Vector normalizar(){
		return this.ponderar(1/this.norma());
	}
	
	public Vector punto(Vector v){
		if (this.dim()!=v.dim())
			return null;
		
		Vector r=new Vector(n);
		
		for (int i=0;i<n;i++)
			r.set(this.get(i)*v.get(i),i);
		
		return r;
	}
	
	////
	
	public static Vector rand(int n){
		Vector v=new Vector(n);
		
		for (int i=0;i<n;i++)
			v.set(Math.random(),i);
		
		return v;
	}
	
	/////

	public static Vector toVector(Matriz m){
		int[] d=m.dim();
		
		Vector v=new Vector(d[0]*d[1]);
		
		for (int i=0;i<d[0];i++)
			for (int j=0;j<d[1];j++)
				v.set(m.get(i,j) , i*d[0]+j);
		
		return v;
	}
	
	public static Matriz toMatriz(int n,int m,Vector v){
		
		Matriz w=new Matriz(n,m);
		double k;
		
		for (int i=0;i<n;i++)
			for (int j=0;j<m;j++){
				k=i*n+j;
				if (k<v.dim())
					w.set(v.get(i) ,i,j);
				else
					w.set(0 ,i,j);
			}			
		
		return w;
	}
}
