
public class Matriz {
	protected double[][] x;
	protected int n,m;
	
	public Matriz(int n,int m){
		x=new double[n][m];
		
		this.n=n;
		this.m=m;
	}
	
	public Matriz(int n,int m,double v){
		x=new double[n][m];
		
		this.n=n;
		this.m=m;
		
		for (int i=0;i<n;i++)
			for (int j=0;j<m;j++)
				x[i][j]=v;
	}
	
	public Matriz(double[][] x){
		this.x=x;
		
		this.n=x.length;
		this.m=x[0].length;
	}
	
	public int[] dim(){
		int[] r=new int[2];
		r[0]=n;
		r[1]=m;
		return r;
	}
	
	public boolean equalsDim(Matriz w){
		int[] d=w.dim();
		return n==d[0] && m==d[1];
	}
	
	public void set(double d,int i,int j){
		x[i][j]=d;
	}
	
	public double get(int i,int j){
		return x[i][j];
	}
	
	public Matriz traspuesta(){
		
		Matriz r=new Matriz(m,n);
		
		for (int i=0;i<m;i++)
			for (int j=0;j<n;j++)
				r.set(this.get(i,j) ,i,j);
		
		return r;
	}
	
	public Matriz getSubmatriz(int i0,int j0,int i1,int j1){
		
		Matriz r=new Matriz(i1-i0,j1-j0);
		
		for (int i=i0;i<i1;i++)
			for (int j=j0;j<j1;j++)
				r.set(this.get(i,j) ,i-i0,j-j0);
		
		return r;
	}
	
	public Matriz setSubmatriz(int i0,int j0,Matriz w){
		
		int[] d=w.dim();
		
		Matriz r=new Matriz(n,m);
		
		for (int i=0;i<n;i++)
			for (int j=0;j<m;j++)
				if (i0<=i && i<i0+d[0])
					r.set(w.get(i-i0,j-j0) ,i,j);
				else
					r.set(this.get(i,j) ,i,j);
		
		return r;
	}
	
	public Matriz ponderar(double a){
		
		Matriz r=new Matriz(n,m);
		
		for (int i=0;i<n;i++)
			for (int j=0;j<m;j++)
				r.set(a*this.get(i,j) ,i,j);
		
		return r;
	}
	
	public Matriz sumar(Matriz w){
		if (!this.equalsDim(w))
			return null;
		
		Matriz r=new Matriz(n,m);
		
		for (int i=0;i<n;i++)
			for (int j=0;j<m;j++)
				r.set(this.get(i,j)+w.get(i,j) ,i,j);
		
		return r;
	}
	
	public Matriz multiplicar(Matriz w){
		int[] d=w.dim();
		if (m!=d[0])
			return null;
		
		Matriz r=new Matriz(n,d[1]);
		
		double s;
		
		for (int i=0;i<n;i++)
			for (int j=0;j<d[1];j++){
				s=0;
				for (int k=0;k<m;k++)
					s+=this.get(i,k)*w.get(k,j);
				r.set(s ,i,j);
			}
		
		return r;
	}
	
	public void print(){
		for (int i=0;i<n;i++){
			U.println("");
			for (int j=0;j<m;j++)
				U.print(this.get(i,j)+"\t");
		}
		U.println("");
	}
	
	////
	
	public static Matriz rand(int n,int m){
		Matriz w=new Matriz(n,m);
		
		for (int i=0;i<n;i++)
			for (int j=0;j<m;j++)
				w.set(Math.random() ,i,j);
		
		return w;
	}
	
	public static Matriz rand(int n){
		return rand(n,n);
	}
	
	public static Matriz id(int n){
		
		Matriz r=new Matriz(n,n);
		
		for (int i=0;i<n;i++)
			for (int j=0;j<n;j++)
				if (i==j)
					r.set(1,i,j);
				else
					r.set(0,i,j);
		
		return r;
	}
}
