
public class Complejo {
	private double x,y;
	
	public Complejo(double x,double y){
		this.x=x;
		this.y=y;
	}
	
	public double real(){
		return x;
	}
	
	public double imag(){
		return y;
	}
	
	public double abs(){
		return Math.sqrt(x*x+y*y);
	}
	
	public double ang(){
		return Math.atan2(y,x);
	}
	
	public Complejo conjugado(){
		return new Complejo(x,-y);
	}
	
	public Complejo sumar(Complejo c){
		return new Complejo(x+c.x,y+c.y);
	}
	
	public Complejo restar(Complejo c){
		return new Complejo(x-c.x,y-c.y);
	}
	
	public Complejo multiplicar(double r){
		return new Complejo(r*x,r*y);
	}
	
	public Complejo multiplicar(Complejo c){
		return new Complejo(x*c.x-y*c.y,y*c.x+x*c.y);
	}
	
	public Complejo invertir(){
		double a=this.abs();
		return this.conjugado().multiplicar(1/(a*a));
	}
	
	public Complejo dividir(Complejo c){
		return this.multiplicar(c.invertir());
	}
}
