
public class Tiempo {
	
	//Variables de instancia
	private int h,m;
	
	//Constructores
	public Tiempo(){
		h=0;
		m=0;
	}
	public Tiempo(int h,int m){
		//se normaliza en caso de tener mas de 60 min
		this.h=h+m/60;
		this.m=m%60;
	}
	public Tiempo(String t){
		int nh=Integer.parseInt(t.substring(0,2));
		int nm=Integer.parseInt(t.substring(3,5));
		
		//se normaliza en caso de tener mas de 60 min
		this.h=nh+nm/60;
		this.m=nm%60;
	}
	
	//mtodos
	public Tiempo suma(Tiempo t){
		int nh=this.h+t.h;
		int nm=this.m+t.m;
		
		//se normaliza en caso de tener mas de 60 min
		nh+=nm/60;
		nm=nm%60;
		
		return new Tiempo(nh,nm);
	}
	
	public Tiempo resta(Tiempo t){
		int nh=this.h-t.h;
		int nm=this.m-t.m;
		
		//se normaliza en caso de tener minutos negativos
		if (nm<0){
			nh-=(-nm)/60;
			nm=(-nm)%60;
		}
		
		//si no se entiende lo anterior, equivale a:
		//while (nm<0){
		//	nm+=60;
		//	nh--;
		//}
		
		return new Tiempo(nh,nm);
	}
	
	public int compareTo(Tiempo t){
		return (this.h*60+this.m)-(t.h*60+t.m);
	}
	
	public String toString(){
		//se dejan h y m en 2 digitos
		//se usa el if de una lnea
		//(condicion ? si es verdadero : si es falso)
		
		String sh=(h<10 ? "0"+h : ""+h);
		String sm=(m<10 ? "0"+m : ""+m);
		
		return sh+":"+sm;
	}
	
	public int minutos(){
		return h*60+m;
	}
}
