import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;


public class MiVentana extends JFrame implements ActionListener{

	
	private static int MAX_NUM=5; 
	
	private JButton miboton;
	private int cont;
	private JLabel[] num;
	
	public MiVentana(String titulo){
		super(titulo);
		cont=0;
		num =new JLabel[MAX_NUM];
		iniciarComponentes();
	}

	private void iniciarComponentes() {
		this.getContentPane().setLayout(null);
		this.getContentPane().setBackground(Color.WHITE);
		this.setBounds(500, 100, 400, 400);
		
		miboton=new JButton(new ImageIcon("imagenes/boton.JPG"));
		this.getContentPane().add(miboton);
		miboton.setBounds(150, 200, 100, 100);
		miboton.addActionListener(this);
		
		String[] img=new String[]{"uno","dos","tres","cuatro","cinco"};
		
		for(int i=0;i<MAX_NUM; i++){
			num[i]=new JLabel(new ImageIcon("imagenes/"+img[i]+".JPG"));
			this.getContentPane().add(num[i]);
			num[i].setBounds(150, 50, 100, 100);
			num[i].setVisible(false);
		}
			
		JLabel extra=new JLabel("Haz click en el (+) de arriba.");
		this.getContentPane().add(extra);
		extra.setBounds(120, 320, 200, 20);		
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		num[cont==0?(MAX_NUM-1):(cont-1)].setVisible(false);
		num[cont].setVisible(true);
		cont=(cont+1)%MAX_NUM;
		//System.out.println(cont);
	}
	

}
