(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15631,        346]
NotebookOptionsPosition[     15117,        324]
NotebookOutlinePosition[     15451,        339]
CellTagsIndexPosition[     15408,        336]
WindowFrame->Generic
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"Dam", "=", "0.034"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tf", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"f", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"r", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{"30.3", "*", 
        RowBox[{"Sin", "[", 
         RowBox[{"k", "[", "t", "]"}], "]"}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"k", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"-", "0.303"}], "-", 
        RowBox[{"Dam", "*", 
         RowBox[{
          RowBox[{"r", "'"}], "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{"r", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"k", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "k"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "0", ",", "tf"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"r", "[", "t", "]"}], "/.", "f"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tf"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"r", "'"}], "[", "t", "]"}], "/.", "f"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "tf"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.432638192073221*^9, 3.43263839312438*^9}, {
   3.432638464946944*^9, 3.432638506699116*^9}, {3.432638554166994*^9, 
   3.432638610764406*^9}, 3.432638675207377*^9, 3.43263873233734*^9, {
   3.432639146554949*^9, 3.432639192662104*^9}, {3.432639408516024*^9, 
   3.432639708382821*^9}, {3.432639744944087*^9, 3.432639972830353*^9}, {
   3.432640314880322*^9, 3.432640318412637*^9}, {3.432640649691559*^9, 
   3.4326406728977*^9}, {3.432640729972549*^9, 3.432640772018788*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"r", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{"k", "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "10.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{
  3.432638435178733*^9, 3.43263847273481*^9, 3.432638578168546*^9, 
   3.432638611585854*^9, 3.432638676080504*^9, 3.432638736386684*^9, {
   3.432639147874997*^9, 3.432639194230641*^9}, {3.432639409377494*^9, 
   3.432639709300367*^9}, {3.432639746204533*^9, 3.432639974671007*^9}, 
   3.432640319371741*^9, {3.432640655940424*^9, 3.432640691626398*^9}, {
   3.432640731006226*^9, 3.432640772697312*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzGk4lG0DxnFL5rElhiRZRvYlKVqQrjtClseSQWmRsUyKyPOOpJRCTGRr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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 10}, {-80.33773400083696, 0.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.432638435178733*^9, 3.43263847273481*^9, 3.432638578168546*^9, 
   3.432638611585854*^9, 3.432638676080504*^9, 3.432638736386684*^9, {
   3.432639147874997*^9, 3.432639194230641*^9}, {3.432639409377494*^9, 
   3.432639709300367*^9}, {3.432639746204533*^9, 3.432639974671007*^9}, 
   3.432640319371741*^9, {3.432640655940424*^9, 3.432640691626398*^9}, {
   3.432640731006226*^9, 3.432640772713305*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwd1nlcTF8bAPCplJpKy7QvM/fOpNIq0Yp5kqJFWoS0aUcUyZKiBVnTgkpU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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, -8.5},
  PlotRange->{{0, 10}, {-8.911323961489787, -5.22952755377145}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.432638435178733*^9, 3.43263847273481*^9, 3.432638578168546*^9, 
   3.432638611585854*^9, 3.432638676080504*^9, 3.432638736386684*^9, {
   3.432639147874997*^9, 3.432639194230641*^9}, {3.432639409377494*^9, 
   3.432639709300367*^9}, {3.432639746204533*^9, 3.432639974671007*^9}, 
   3.432640319371741*^9, {3.432640655940424*^9, 3.432640691626398*^9}, {
   3.432640731006226*^9, 3.432640772728937*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "[", "8", "]"}], "/.", "f"}]], "Input",
 CellChangeTimes->{{3.432640384402508*^9, 3.432640407580683*^9}, {
  3.432640791385555*^9, 3.432640839916059*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"-", "0.2984231515824606`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.432640408081486*^9, {3.432640797986543*^9, 3.432640840913546*^9}}]
}, Open  ]]
},
WindowSize->{1280, 725},
WindowMargins->{{0, Automatic}, {24, Automatic}},
FrontEndVersion->"6.0 for Linux x86 (32-bit) (April 20, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[591, 23, 2008, 55, 97, "Input"],
Cell[2602, 80, 1069, 30, 28, "Output"],
Cell[3674, 112, 3664, 66, 232, "Output"],
Cell[7341, 180, 7350, 126, 227, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14728, 311, 193, 4, 28, "Input"],
Cell[14924, 317, 177, 4, 28, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

