function estabilizacion_pendulo_invertido
clear all; close all; clc;
global M m L g; 
M=10;
m=1;
L=1;
g=9.8;

% Se definen las matrices A y B del sistema
A = [ 0     1     0         0
      0     0  -m*g/M       0
      0     0     0         1
      0     0 (M+m)*g/(L*M) 0 ];
  
B = [  0
      1/M 
       0
     -1/(L*M) ];

xinic = [0.5 0.2 0.4 4];
%xinic = [0.5 0.2 0.4 1];

% Estabilizacion via lqr
[K,S,e] = lqr(A,B,eye(4),1);
%xinic = [0.5 0.2 0.4 1 ];
[t,x] = ode45(@sistema,[0 20],xinic,[],K);
figure('Name','Estabilizacion LQR');
subplot(2,2,1); plot(t,x(:,1)); title('x1');
subplot(2,2,2); plot(t,x(:,2)); title('x1punto');
subplot(2,2,3); plot(t,x(:,3)); title('theta');
subplot(2,2,4); plot(t,x(:,4)); title('thetapunto');

%pause;

% Estabilizacion via localizacion de polos: Uso de acker.m
K=acker(A,B,[-1,-2,-3,-4]);
%xinic = [0.5 0.2 0.4 1 ];
[t,x] = ode45(@sistema,[0 20],xinic,[],K);
figure('Name','Estabilizacion via localizacion de polos: Uso de acker.m');
subplot(2,2,1); plot(t,x(:,1)); title('x1');
subplot(2,2,2); plot(t,x(:,2)); title('x1punto');
subplot(2,2,3); plot(t,x(:,3)); title('theta');
subplot(2,2,4); plot(t,x(:,4)); title('thetapunto');

% Estabilizacion via localizacion de polos: Uso de place.m
K=place(A,B,[-1,-2,-3,-4]);
%xinic = [0.5 0.2 0.4 1 ];
[t,x] = ode45(@sistema,[0 20],xinic,[],K);
figure('Name','Estabilizacion via localizacion de polos: Uso de place.m');
subplot(2,2,1); plot(t,x(:,1)); title('x1');
subplot(2,2,2); plot(t,x(:,2)); title('x1punto');
subplot(2,2,3); plot(t,x(:,3)); title('theta');
subplot(2,2,4); plot(t,x(:,4)); title('thetapunto');

%--------------------------------------------------------------------------
function xpunto = sistema(t,x,K)
global M m L g ;
u = -K*x;
xpunto = [ x(2)
           (m*L*x(4)^2*sin(x(3))-m*g*cos(x(3))*sin(x(3))+u)/(M+m*sin(x(3))^2)
           x(4)
           (-m*L*x(4)^2*sin(x(3))*cos(x(3))+(M+m)*g*sin(x(3))-u*cos(x(3)))/(L*(M+m*sin(x(3))^2)) ];
 