function ricatti2

% Sistema dx/dt=y, dy/dt=z, dz/dt=u
% min int_0^infty (x^2+y^2+z^2+u^2)dt

clc; clear all; 

global A B W invU;

% Dinamica
A = [0 1 0
     0 0 1
     0 0 0];
 
B = [ 0; 0; 1];

% Matrices de ponderacion

W=eye(3);
U=1; 
invU=inv(U);

rango = [0 : 0.01 : 10];

% Utilizacion de lqr

global K;

[K,S,e] = lqr(A,B,W,U);

% Integracion el sistema con control retroalimentado

xinic =[1; 2; 3];
[t,X]=ode45(@SistemaRiccati,rango,xinic);

% Despliegue de la solucion

plot(t,X(:,1));

%----------------------------------------------

function dXdt = SistemaRiccati(t,X)

global K;

u=-K*X;


dXdt = [ X(2); X(3); u];

