function ricatti1

% Sistema dx/dt=y, dy/dt=z, dz/dt=u
% min int_0^T (x^2+y^2+z^2+u^2)dt

clc; clear all; close all;
rango = [0 : 0.01 : 10];

global tricca ricca;
matrizinit = [0; 0; 0; 0; 0; 0];
[tricca,ricca] = ode113(@RiccatiMatricial,rango,matrizinit);
ricca = flipud(ricca); % Reponemos el tiempo en el buen sentido

xinit = [ 1; 2; 3];
[t,X] = ode113(@SistemaRiccati,rango,xinit);

plot(t, X(:,1))

%----------------------------------------------

function dXdt = SistemaRiccati(t,X)

global tricca ricca;
[bla, k]=min(abs(tricca-t));

e=ricca(k,5); f=ricca(k,6); c=ricca(k,3);
u=e*X(1)+f*X(2)+c*X(3); % Control feedback u=inv(U)B'Ex

dXdt = [ X(2); X(3); u];

%----------------------------------------------

function dXdt = RiccatiMatricial(t,X)

% Ecuacion matricial de Riccati dE/dt=W-A'E-EA-EB*inv(U)B'E, E(T)=-Q
% en tiempo inverso

dXdt = -[ 1-X(5)^2; -2*X(4)-X(6)^2+1; -2*X(6)-X(3)^2+1; -X(1)-X(5)*X(6); -X(4)-X(5)*X(3); -X(5)-X(2)-X(6)*X(3)];
