function dv = ejemplo3_ode(t,v,P)
% IQ57A: Dinmica y control de Procesos
%
% J. Cristian Salgado
% jsalgado@ing.uchile.cl
%
% Departamento de Ingeniera Qumica y Biotecnologa
% Universidad de Chile
%
% 10/08/08
%
% Ejemplo de modelacion con ODES
%% Capturamos las variables (solo para facilitar lectura)
h1 = v(1);
h2 = v(2);
h3 = v(3);

%% Ecuaciones
dh1 = (P.F1 - h1/P.R1)/P.Area;
dh2 = (h1/P.R1 - (1/P.R2 + 1/P.R3)*h2)/P.Area;
dh3 = (h2/P.R2 - h3/P.R4)/P.Area;

dv = [dh1 dh2 dh3]';