% IQ57A: Dinmica y control de Procesos
%
% J. Cristian Salgado
% jsalgado@ing.uchile.cl
%
% Departamento de Ingeniera Qumica y Biotecnologa
% Universidad de Chile
%
% 10/08/08
%
% Ejemplo de modelacion con ODES

clear all;

%% Datos
P.rho  = 1 ;    % Densidad del agua: [kg / lt]
P.Area = 10;    % Area de los tanques: [m^2]
P.R1   = 0.5;   % Constante de descarga del tanque 1: [s / m^2]
P.R2   = 0.5;   % Constante de descarga del tanque 2: [s / m^2]
P.R3   = 0.3;   % Constante de descarga del tanque 2: [s / m^2]
P.R4   = 0.9;   % Constante de descarga del tanque 4: [s / m^2]
P.F1   = 1;   % Flujo de entrada: [m^3 / s]

%% Condiciones iniciales

h1_0 = 0;   % Altura del tanque 1: [m]
h2_0 = 0;   % Altura del tanque 2: [m]
h3_0 = 0;   % Altura del tanque 3: [m]

% Vector de condiciones iniciales
v_0 = [h1_0 h2_0 h3_0];


%% Parametros para el integrador
options = odeset('RelTol', 1e-6, 'AbsTol', 1e-9);

t_i1    = 0;
t_step1 = 1;
t_f1    = 70;
F1_1    = 1;

t_i2    = t_f1;
t_step2 = 1;
t_f2    = t_f1*2;
F1_2    = 2;

tspan1  = [t_i1:t_step1:t_f1];
tspan2  = [t_i2:t_step2:t_f2];

%% Simulacin

% Primera parte
P.F1   = F1_1;
[t1,v1] = ode45(@(t,v) ejemplo3_ode(t,v,P), tspan1, v_0, options);

% Segunda parte
P.F1   = F1_2;
[t2,v2] = ode45(@(t,v) ejemplo3_ode(t,v,P), tspan2, v1(end,:), options);

t  = [t1; t2];
v  = [v1; v2];
F1 = [ones(size(t1))*F1_1; ones(size(t2))*F1_2];

%% Plots
h = plot(t,F1,t,v(:,1),t,v(:,2),t,v(:,3));
legend('F_1 [m^3/s]','h_1 [m]','h_2 [m]','h_3 [m]');
xlabel('t [s]');
ylabel('h [m]');
title('Altura de los estanques en funcin del tiempo');

set(h,'LineWidth',3);
set(gca,'Ylim',[0 2.2]);