function xf=trayectoria(m,tfin,dt,coeficienteroce,angulo,velinicial,ymax)
%trayectoria(m,tfin,dt,coeficienteroce,angulo,velinicial,ymax) retorna el
%alcance del proyectil y grfica la trayectoria
%m=masa
%tfin=tiempo final designado para la discretizacion
%dt=particion de tiempo
%coeficienteroce=coeficiente de roce del aire
%angulo=angulo de lanzamiento
%velinicial=velocidad inicial de lanzamiento
%ymax es el valor maximo del grfico a entregar, en el eje vertical
gam=coeficienteroce;
alfa=angulo;
V0=velinicial;
g=9.8;
x0=0;y0=0;
Vxo=V0*cos(alfa);
t=0:dt:tfin;
x=zeros(1,length(t));
x(1)=x0;
x(2)=Vxo*cos(alfa)*dt;
for i=2:length(t)-1
    x(i+1)=x(i)*(2-(gam*dt)/m)+x(i-1)*((gam*dt)/m-1);
end

Vyo=V0*sin(alfa);
y=zeros(1,length(t));
y(1)=y0;
y(2)=Vyo*sin(alfa)*dt;
for i=2:length(t)-1
    y(i+1)=y(i)*(2-(gam*dt)/m)+y(i-1)*((gam*dt)/m-1)-dt^(2)*g;
end



for j=2:length(t)
    if(y(j)==0)
        xf=x(j);
        ind=j;
        break;
    end
    if(y(j)*y(j-1)<0)
        xf=(x(j)+x(j-1))/2;
        ind=j;
        break;
    end
end

plot(x,y)
xlim([0 x(ind+1)])
ylim([0 ymax])
title('Trayectoria de proyectil')
xlabel('X[mts]')
ylabel('Y[mts]')
