function [x,t] = VerletOscForzado(m,M,b,k,Yo,w,x0,v0,dt,tf,check)

%VerletOscForzado(m,M,b,k,Yo,w,x0,v0,dt,tf,check) resuelve la ecuacin de
%movimiento de un sistema dinmico de un grado de libertad, sometido a una
%carga externa oscilante de la forma m*Yo*w^2*sen(w*t). 
%La ecuacin de movimiento (M+m)*xpp+b*xp+k*x=m*Yo*w^2*sen(w*t) es integrada mediante
%el mtodo de Verlet. Se asume que la posicin en el instante 2 
%(tinicio+dt) vara linealmente respecto de la posicin original x0, es 
%decir, x1=x0+v0*dt
% 
%VerletOscForzado retorna el vector de posiciones en el tiempo [x] y la 
%serie de tiempo utilizada [t].
%
% M:     Masa del carro (en kg)
% m:     Masa del forzaje (en kg)
% b:     Coeficiente de roce viscoso (en kg/s)
% k:     Rigidez (en N/m)
% Yo:    Amplitud mxima de movimiento de la carga forzante (en m)
% w:    Frecuencia de la carga forzante (en rad/s)
% x0:    Posicin inicial (en m)
% v0:   Velocidad inicial (en m/s)
% dt:    Paso de tiempo (en s)
% tf:    Tiempo final (en s)
% check: check=1 grafica la solucion. No es necesario ingresarlo si no se desea graficar

%Generamos el vector de tiempo:
t=(0:dt:tf);

%Calculamos frecuencia y perodo
wo=(k/(M+m))^(1/2);
fo = wo/2/pi;
T=2*pi/wo;
tau = (m+M)/b;
%Cc=2*m*wo;
%B=b/Cc;

%Desplegamos en pantalla:
disp([sprintf('Frecuencia de resonancia wo= %g',wo) ' rad/s'])
disp([sprintf('Periodo T= %g',T) ' s'])
disp([sprintf('Tiempo de decaimiento tau= %g',tau) ' s'])
%disp(strcat(sprintf('Amortiguamiento = %g',round(B*100)), '%'))

%Definimos x(t):
x=zeros(1,length(t));
x(1)=x0;
x(2)=v0*dt+x0;

%RESOLUCION POR METODO DE VERLET
for i=2:length(t)-1
    x(i+1)=dt^2*m*Yo*w^2*sin(w*t(i))/(M+m) - dt*(x(i)-x(i-1))/(tau) - wo^2*dt^2*x(i) + 2*x(i) - x(i-1);
end

%Graficamos
if nargin>9
    if check==1
        plot(t,x)
        title('Posicion vs Tiempo: x(t)','FontSize',18)
        xlabel('Tiempo (s)','FontSize',16)
        ylabel('Posicion (m)','FontSize',16)
        grid on
    end
end

%Creado por Cristian Cruz D.
%Comentarios a cristiancrux@gmail.com
%modificado por N. Mujica 



