%************************************************************
%** Nombre:      IdentificaPCA
%**
%** Descripcion: Mtodo que asigna un ID a una imagen de entrada 
%**              utilizando un clasificador PCA.
%**              Ojo!! Solo sirve para Tarea 3 de EM752. 
%** Entradas: 
%**             imgname: Nombre de la imagen a identificar.
%**             CA: Cell Array de caracteristicas de imgenes en Base de datos.
%**             Vecs: Vectores de proyeccin en espacio PCA.
%** Salida:
%**             nId: Numero de individuo que el sistema identifica con la
%**             imagen de entrada
%**
%** Fecha: 24-10-07
%** Autor: LMD
%**
%************************************************************
function nId = IdentificaPCA(imgname,CA,Vecs)

%contenido Cell Array CA
indiceProyeccion = 2;
indiceID = 1;

%Tamao de BD
NBD=size(CA',1);

%Abrir imagen
if(findstr('.bmp',imgname))
    fprintf(1,'Cargando archivo BMP %s\n',imgname);
    Img = imread(imgname); %Leer imagen BMP como matriz
end;

%Normalizacion estadistica
Img = double(reshape(Img',prod(size(Img)),1));   % Vector columna
Img = (Img-mean(Img))/std(Img);

%Proyectar
%Vecs(:,10) contiene el promedio de las imagenes como vectores
Projection = Vecs(:,1:9)'*(Img - Vecs(:,10));

% Recorrer BD
for nj = 1:NBD,
    fd(nj)=norm(Projection-CA{nj}{indiceProyeccion});        
end;

%Gana quien tiene menor distancia al individuo de test
indice = find(fd == min(fd));
nId=CA{indice}{indiceID};