% This program solves problem 6.11 of the book:
% Fundamentals of Power System Economics
% To run it, type:
%
% p6_11
%
% This program internally calls the function p6_10.m
clc, clear
disp('   Solution of problem 6.11, "Fundamentals of Power System Economics"')

K=linspace(0,0.0005,100); % array containing 100 linearly spaced values of K within the range 0 to 0.0005

for a=1:length(K)
    [PA(a),PB(a),lambda(a),FAB(a),pA(a),pB(a),losses(a)]=p6_10(K(a));  % calls the function p6._10.m
end

figure(1)
plot(K,losses,'-k',K,-FAB,':b')
xlabel('K, MW^-^1','fontsize',13)
ylabel('MW','fontsize',13)
legend('losses','F_B_A',0)
axis tight

figure(2)
plot(K,pA,'-k',K,pB,':b')
xlabel('K, MW^-^1','fontsize',13)
ylabel('$/MWh','fontsize',13)
legend('MC_A','MC_B',0)
axis tight

figure(3)
plot(K,PA,'-k',K,PB,':b')
xlabel('K, MW^-^1','fontsize',13)
ylabel('MW','fontsize',13)
legend('P_A','P_B',0)
axis tight