function [PA,PB,lambda,FAB,pA,pB,losses]=p6_10(K)
% This function solves problem 6.10 of the book:
% Fundamentals of Power System Economics
% To solve, type the following:
%
%    [PA,PB,lambda,FAB,pA,pB,losses]=p6_10(K)
%
% Where: PA is the power generated at A in MW (output)
%        PB is the power generated at B in MW (output)
%        lambda is the value Lagrange multiplier associated 
%               with the constraint in $/MWh (output)
%        FAB is the power flow from A to B in MW (output)
%        pA is the marginal cost at A in $/MWh (output)
%        pB is the marginal cost at B in $/MWh (output)
%        losses are the transmission losses in MW (output)
% and    K is the factor in 1/MW  (input)

DA = 2000;  % demand at A in MW
DB = 1000;  % demand at B in MW

PA = 2000;  % initial guess of the power generated at A in MW
PB = 1000;  % initila guess of the power generated at B in MW
lambda = 1; % initial guess of the constraint cost in $/MWh
err=1;      % initial guess of the error
iter=0;     % iteration

while err>1e-9
    iter=iter+1;
    g=[20+0.03*PA+lambda*(2*K*PA-2*K*DA-1)
       15+0.02*PB-lambda
       DA+DB+K*PA^2-2*K*PA*DA+K*DA^2-PA-PB];
       
    J=[0.03+lambda*2*K       0       2*K*PA-2*K*DA-1
        0                 0.02     -1
       2*K*PA-2*K*DA-1    -1   0];
   DP=inv(J)*-g;
   PA=PA+DP(1);
   PB=PB+DP(2);
   lambda=lambda+DP(3);
   err=max(abs(DP));
end
PA;
PB;
lambda;
FAB=PA-DA;
pA=20+0.03*PA;
pB=15+0.02*PB;
losses=PA+PB-DA-DB;