function [t,x]=p5_4and5_5b(Pgen,E,Vinf,H,f,Xeq1,Xeq2,Xeq3,tf,tfd,t_end)
% This function integrates the swing equations of the generating units
% for the different periods, that is, pre-fault, fault and after fault.
% This function requires the following sub-functions:
% p5_4and5_5ba which contains the swing equations for the pre-fault period
% p5_4and5_5bb which contains the swing equations for the fault period
% p5_4and5_5bc whoch contains the swing equations for the post-fault period

global Pm E Vinf Xeq1 Xeq2 Xeq3 H f
Pm=Pgen;

Pe1max = E*Vinf/Xeq1; Pe2max=E*Vinf/Xeq2; Pe3max=E*Vinf/Xeq3;
fprintf('\n   The fault duration is: %2.3f sec; starting at %2.3f and ending at %2.3f sec  \n',tfd,tf,tf+tfd)

options=odeset('Maxstep',1e-3); % maximum integrating step

% first segment of the integration
dss=asin(Pm/Pe1max);
x0ss=[dss, 0];
tspan=[0, tf];
[t_0,xs]=ode45(@p5_4and5_5ba,tspan,x0ss,options); % Pre-fault

% second segment of the integration
x0f=xs(size(xs,1),:);
tspan=[tf,tf+tfd];
[t_1,xf]=ode45(@p5_4and5_5bb,tspan,x0f,options); % During fault

% third segment of the integration
x0pf=xf(size(xf,1),:);
tspan=[tf+tfd,t_end];
[t_2,xpf]=ode45(@p5_4and5_5bc, tspan, x0pf,options); % Post-fault

% commulative output
t=combine(t_0,t_1,t_2);
x=combine(xs,xf,xpf);



