function [Vx,Ax,P12,Q12]=p5_4and5_5a(Pgen)
% This function solves the power flow for the 2 bus
% system of poblems 5.4 and 5.5 of the book:
% Fundamentals of Power System Economics
% Vx is the magnitude of the voltage at bus 2 in p.u. (output)
% Ax is the angle of the voltage at bus 2 in degrees  (output)
% P12 is the active power flow from 1 to 2 in p.u.    (output)
% Q12 is the reactive power flow from 1 to 2 in p.u.  (output)
% Pgen is the active power generated at bus 1 in p.u. (input)

fprintf('\n    -----   Power Generated = %2.5f p.u.   --- \n',Pgen)
n=2;
Ybus=[-10-1e-6 10;10 -10]*i;

B1=-imag(Ybus(2:n,2:n));
B2=-imag(Ybus(2:n-1,2:n-1));

% Voltage at buses
V=[1.00; 1.00]; % flat start

Pespc=[0; 0];       % especified load
Pespg=[-1; 1]*Pgen; % especified generation
Pesp=Pespc+Pespg;
Qesp=[0.0; 0.0];    % reactive power injection specified

dsjt=1;
iter=0;
while abs(dsjt) > 1e-9
   Scalc=conj(V).*(Ybus*V);     
   Pcalc=real(Scalc);
   Qcalc=-imag(Scalc);
   DP=Pesp(2:n)-Pcalc(2:n);     
   DQ=Qesp(2:n-1)-Qcalc(2:n-1); 
   incrAng=inv(B1)*(DP./abs(V(2:n))); 
   incrV=inv(B2)*(DQ./abs(V(2:n-1)));     
   V=(abs(V)+[0;incrV;0]).*exp(i*(angle(V)+[0;incrAng]));
   dsjt=max([abs(max(DP)),abs(max(DQ))]); 
   iter=iter+1;
end
fprintf('\n   |maximum deviation| = %1.10f\n   iteration = %2d\n',dsjt,iter)
fprintf('\n   Vm   = %2.2f p.u.,   angle_m   = %2.2f deg',abs(V(2)),angle(V(2))*180/pi)
fprintf('\n   Vinf = %2.2f p.u.,   angle_inf = %2.2f deg',abs(V(1)),angle(V(1))*180/pi)
Vx=abs(V(2));
Ax=angle(V(2))*180/pi;
I=Ybus*V;
U12=V(2)*conj(I(2));
P12=real(U12);
Q12=imag(U12);
fprintf('\n   P12 = %2.5f p.u.\n   Q12 = %2.5f p.u.\n\n',P12,Q12)