% This program solves problems 5.4 and 5.5 of the book:
% Fundamentals of Power System Economics
% To run it, type:
%
% p5_4and5_5
%
% This program internally calls the following functions:
% p5_4and5_5a   which solves the power flow for the system

clc, clear all, warning off
global Pm E Vinf Xeq1 Xeq2 Xeq3 H f
disp('   Problem 5.4  and 5.5, Fundamentals of Power System Economics')
prob=menu('Which problem would you like to solve?','Problem 5.4','Problem 5.5');

Pgen=1.0173;   % Power generated at bus 1, p.u.
Vinf=1;        % voltage of the infinite bus
% data for the dynamic simulation
Xg=0.8;       % internal reactance of the generating unit, p.u.
if prob==1     % for problem 5.4
    fprintf('\n   The data for problem 5.4 has been loaded\n')
    Xeq1=0.1+Xg;         % pre-fault reactance between 1 and 2, p.u.
    Xeq2=999+Xg;         % fault reactance between 1 and 2, p.u.
    Xeq3=0.2+Xg;         % post-fault reactance between 1 and 2, p.u.
elseif prob==2 % for problem 5.5
    fprintf('\n   The data for problem 5.5 has been loaded\n')
    Xeq1=0.05+Xg;        % pre-fault reactance between 1 and 2, p.u.
    Xeq2=999+Xg;         % fault reactance between 1 and 2, p.u.
    Xeq3=2/30+Xg;        % post-fault reactance between 1 and 2, p.u.
end
H=3;          % inertia of the generating unit in sec
freq=menu('What is the system frequency?','50 Hz','60 Hz');
if freq==1
    f=50;
elseif freq==2
    f=60;         % system frequency
end
tf=0.2;       % time at which the fault is applied, sec
tfd=0.12;     % fault duration, sec
t_end=1.5;    % final time for the simulation sec

fprintf('\n   The system is operating at f = %2d Hz\n',f)

% Solving the power flow for the system
[V1,A1,P12,Q12]=p5_4and5_5a(Pgen);

% calculation of the internal voltage of the generator
Eph=conj((P12+i*Q12)/(V1*exp(i*A1*pi/180)))*i*Xg+V1*exp(i*A1*pi/180);
E=abs(Eph);
ag=angle(Eph);

% Confirmation of the internal angle of the generating unit
dP=asin(Pgen/(Vinf*E/(Xeq1)));  % this result is equal to ag

% the dynamic simulation is computed
[t,x]=p5_4and5_5b(Pgen,E,Vinf,H,f,Xeq1,Xeq2,Xeq3,tf,tfd,t_end);

figure(1)
subplot(2,2,1)
plot(t, x(:,1)*180/pi,'-k','linewidth',2)
xlabel('time, sec','fontsize',13)
ylabel('delta, degrees','fontsize',13)

%figure(2)
subplot(2,2,2)
plot(t,x(:,2)./(2*pi)+f,'-k','linewidth',2)
xlabel('time, sec','fontsize',13)
ylabel('f, Hz','fontsize',13)

for a=1:size(t,1) % calculation of the electrical power
    if t(a)<=tf
        Pe(a)=E*Vinf/Xeq1*sin(x(a,1));
    elseif t(a)>tf & t(a)<=tf+tfd
        Pe(a)=E*Vinf/Xeq2*sin(x(a,1));
    elseif t(a)>tf+tfd
        Pe(a)=E*Vinf/Xeq3*sin(x(a,1));
    end
end
%figure(3)
subplot(2,2,3)
plot(t,Pe,'-k','linewidth',2)
xlabel('time, sec','fontsize',13)
ylabel('Pe, p.u.','fontsize',13)

subplot(2,2,4)
plot(x(:,1)*180/pi,Pe,'-k','linewidth',2)
hold on
plot(x(:,1)*180/pi,Pgen*ones(1,size(x,1)),':b','linewidth',2)
xlabel('delta, degrees','fontsize',13)
ylabel('P, p.u.','fontsize',13)
legend('Pe','Pm',0)
hold off