#include <stdio.h>
#include "nSystem.h"

#define SGTE 1
#define OK   2
#define FIN  3

typedef struct Node {
  struct Node *izq, *der;
  int valor;
} Node;

int valorArbol1;
int valorArbol2;
int msgArbol1;
int msgArbol2;
Node *arbol1;
Node *arbol2;
nMonitor ctrl;


Node * crear(int valor, Node *izq, Node *der){
  Node *p = (Node *) nMalloc(sizeof(Node));
  p->valor = valor;
  p->izq = izq;
  p->der = der;
  return p;
}


int recorrerArbol1();
int recorrerArbol2();


nMain(){
  arbol1 = crear(10,
                  crear(7, crear(3, NULL,NULL), crear(9, NULL,NULL)),
                  crear(13, crear(12, NULL,NULL), NULL));
  arbol2 = crear(8,
                  crear(3, NULL,NULL),
                  crear(15, crear(12, NULL,NULL),NULL));
  ctrl = nMakeMonitor();
  msgArbol1 = SGTE;
  msgArbol2 = SGTE;
  nTask t1=nEmitTask(recorrerArbol1);
  nTask t2=nEmitTask(recorrerArbol2);
  nPrintf("Lista ordenada de nodos:\n");
  nEnter(ctrl);
  for(;;){
    while(msgArbol1 == SGTE || msgArbol2 == SGTE){
        nWait(ctrl);
    }
    int sgte;
    if(msgArbol1 == FIN && msgArbol2 == FIN) {
        break;
    } else if(msgArbol1 == FIN) {
        sgte = valorArbol2; msgArbol2 = SGTE;
    } else if(msgArbol2 == FIN){
        sgte = valorArbol1; msgArbol1 = SGTE;
    } else if(valorArbol1 <= valorArbol2){
        sgte = valorArbol1; msgArbol1 = SGTE;
    } else {
        sgte = valorArbol2; msgArbol2 = SGTE;
    }
    nPrintf(" %i", sgte);
    nNotifyAll(ctrl);
  }
  nExit(ctrl);
  nWaitTask(t1);
  nWaitTask(t2);
  nPrintf("\nFin\n");
}

int recorrerArbol1(){
    nEnter(ctrl);
    recorrerRec1(arbol1);
    while(msgArbol1 != SGTE){
      nWait(ctrl);
    }
    msgArbol1 = FIN;
    nNotifyAll(ctrl);
    nExit(ctrl);
}
int recorrerArbol2(){
    nEnter(ctrl);
    recorrerRec2(arbol2);
    while(msgArbol2 != SGTE){
      nWait(ctrl);
    }
    msgArbol2 = FIN;
    nNotifyAll(ctrl);
    nExit(ctrl);
}


recorrerRec1(Node * nodo){
    if(nodo == NULL)
        return;
    recorrerRec1(nodo->izq);
    while(msgArbol1 != SGTE){
      nWait(ctrl);
    }
    valorArbol1 = nodo->valor;
    msgArbol1 = OK;
    nNotifyAll(ctrl);
    recorrerRec1(nodo->der);
}

recorrerRec2(Node * nodo){
    if(nodo == NULL)
        return;
    recorrerRec2(nodo->izq);
    while(msgArbol2 != SGTE){
      nWait(ctrl);
    }
    valorArbol2 = nodo->valor;
    msgArbol2 = OK;
    nNotifyAll(ctrl);
    recorrerRec2(nodo->der);
}
