;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(lib "reader.ss" "plai" "lang")
(define new-counter (lambda () (box 0)))

(define inc (lambda (counter-box) 
              (begin
                (set-box! counter-box (+ (unbox counter-box) 1))
                (unbox counter-box))))

(define dec (lambda (counter-box)
              (begin
                (set-box! counter-box (- (unbox counter-box) 1))
                (unbox counter-box))))

(define c (new-counter))
(test (inc c) 1)
(test (dec c) 0)


(define new-stack (lambda () (box empty)))

(define push (lambda (stack val) (set-box! stack (cons val (unbox stack)))))

(define peek (lambda (stack) (car (unbox stack))))

(define pop (lambda (stack)
              (let ((old-val (peek stack)))
                (begin
                  (set-box! stack (cdr (unbox stack)))
                  old-val))))

(define stack (new-stack))
(push stack 1)
(push stack 2)
(test (pop stack) 2)
(test (peek stack) 1)