(define-type ALE
  (id  (v VAR?))
  (add (l ALE?) (r ALE?))
  (sub (l ALE?) (r ALE?))
)
(define-type VAR
  (var (coef number?) (x symbol?)))

;;parse::S-exp -> ALE
(define (parse sexp)
  (cond
    ((number? (first sexp)) (id (var (first sexp) (second sexp))))
    ((symbol=? '+ (first sexp)) (add (parse (second sexp)) (parse (third sexp))))
    ((symbol=? '- (first sexp)) (sub (parse (second sexp)) (parse (third sexp))))
    )
  )

;;pp::ALE -> string
(define (pp ale)
  (type-case ALE ale
             (id (x) (ppVar x))
             (add (l r) (string-append "( " (pp l) " + " (pp r) " )"))
             (sub (l r) (string-append "( "(pp l) " - " (pp r) " )"))
             )
  )
(define (ppVar var-x)
  (type-case VAR var-x
             (var (c x) (cond 
                          ((= c 1)(symbol->string x))
                          ((= c -1)(string-append "(-" (symbol->string x) ")" ))
                          ((> c 1)(string-append (number->string c) (symbol->string x)))
                          ((< c -1)(string-append "(" (number->string c) (symbol->string x) ")" ))
                          (else "0")
                          )))
  )

;;list->set::List-of-symbol -> List-of-symbol
(define (list->set ls)
  (if (empty? ls) '() (cons (first ls) (list->set (remove* (list (first ls)) ls))))
  )

;;x-var:: VAR -> symbol
(define (x-var var-x) (type-case VAR var-x (var (c x) x)))
;;c-var:: VAR -> number
(define (c-var var-x) (type-case VAR var-x (var (c x) c)))

;;Ejercicio 3 - Control
;;   |
;;   v 

;;Inicio --simp
;; Fx de Simplificaci'on, 0.5 pto
;;
;;simp:: ALE -> ALE
(define (simp ale) (make-simple-ale (list->set (list-var ale)) ale))
;;
;;make-simple-ale::List-of-symbol -> ALE
(define (make-simple-ale ls ale)
 (if (= (length ls) 1) (id (var (calc (car ls) ale) (car ls)))
     (add (id (var (calc (car ls) ale) (car ls))) (make-simple-ale (cdr ls) ale))))
;;
;;Fin --simp

;;calc::symbol, ALE -> number
;; Calculo de la simplificaci'on, 0.5 pto
(define (calc a ale)
  (type-case ALE ale
             (id (x) (if (symbol=? a (x-var x)) (c-var x) 0))
             (add (l r) (+ (calc a l) (calc a r)))             
             (sub (l r) (- (calc a l) (calc a r)))             
             )
  )

;;list-var:: ALE -> List-of-symbol
;; Extraer variables desde el ALE, 0.5 pto
(define (list-var ale)
  (type-case ALE ale
             (id (x) (list (x-var x)))
             (add (l r) (append (list-var l) (list-var r)))             
             (sub (l r) (append (list-var l) (list-var r)))             
             )
  )

;;test
(test (pp (simp (parse '{2 a}))) "2a")
(test (pp (simp (parse '{+ {1 a} {2 a}}))) "3a")
(pp (parse '{+ {- {- {+ {3 a} {1 b}} {1 a}} {2 c}} {+ {-3 c} {2 b}}}))
(test (pp (simp (parse '{+ {- {- {+ {3 a} {1 b}} {1 a}} {2 c}} {+ {-3 c} {2 b}}}))) 
      "( 2a + ( 3b + (-5c) ) )")
