;; filter-<- :: Number, List-of-Number -> List-of-Number
;; 0.1 pto contrato
;; 0.2 pto impl. fx
(define filter-<-
  (lambda (x ls)
    (cond
      ((null? ls) '())
      ((< (car ls) x) (cons (car ls) (filter-<- x (cdr ls))))
      (else (filter-<- x (cdr ls)))
      )
    )
  )

;; filter-<-* :: Number, List-of-List-of-Number -> List-of-List-of-Number
;; 0.1 pto contrato
;; 0.4 pto impl. fx
(define filter-<-*
  (lambda (x lls)
    (cond
      ((null? lls) '())
      ((list? (car lls)) (cons (filter-<-* x (car lls)) (filter-<-* x (cdr lls))))
      ((and (number? (car lls)) (< (car lls) x)) 
       (cons (car lls) (filter-<-* x (cdr lls))))            
      (else (filter-<-* x (cdr lls)))
      )
    )
  )

;; filter :: (Number -> Bool), List-of-List-of-Number -> List-of-List-of-number
;; 0.1 pto contrato
;; 0.4 pto impl. fx
(define filter!
  (lambda (f lls)
    (cond
      ((null? lls) '())
      ((list? (car lls)) (cons (filter! f (car lls)) (filter! f (cdr lls))))
      ((and (number? (car lls)) (f (car lls))) 
       (cons (car lls) (filter! f (cdr lls))))            
      (else (filter! f (cdr lls)))
      )
    )
  )
;; filter-<-- :: Number, List-of-List-of-Number -> List-of-List-of-number
;; 0.1 pto impl. fx
(define (filter-<-- x ls) (filter! (lambda (l) (< l x)) ls))

;; filter->-- :: Number, List-of-List-of-Number -> List-of-List-of-number
;; 0.1 pto impl. fx
(define (filter->-- x ls) (filter! (lambda (l) (> l x)) ls))


;;tests
(test (filter-<- 5 '(1 3 8 4 6)) '(1 3 4))
(test (filter-<-* 5 '(1 3 (8 4 ((6))))) '(1 3 (4 (()))))
(test (filter-<-- 5 '(1 3 (8 4 ((6))))) '(1 3 (4 (()))))
(test (filter->-- 5 '(10 30 (1 40 ((2))))) '(10 30 (40 (()))))
(test (filter! number? '(a 2 3 d r 4)) '(2 3 4))