;; AUX 1 . CC41A 
;; Oscar E A Callau
;; con colaboracion de Richard Ibarra

;; DrScheme -> Language -> Chosee language -> Standard (R5R6)

;; Las líneas iniciadas con ';' son comentarios
;; Puede descomentar las líneas que indican pruebas y ejecutar sus propios experimentos.
;; Para ello puede utilizar la línea de comandos de DrScheme '>'.
;; Asegúrese que entiende la definición de funciones, tras diversas pruebas que ejecute.

;; BOOLEANOS

;; #t -> true
;; #f -> false
;;
;; Funciones lógicas para boleanos : not, and, or

;; LISTAS

;; car : list -> atom          '' Primer elemento de una lista
;; cdr : list -> list          '' Resto de la lista
;; cons : atom x list -> list    '' Retorna una nueva lista añadiendo una elemento al principio
;; append : list x list -> list  '' Retorna una nueva lista resultante de 'pegar' dos listas
;; (list 1 2 3)                '' Crea una nueva lista
;; '(1 2 3)                    '' Igual que el anterior, notar el ' delante del primer paréntesis.
;; '()                         '' Lista vacía
;; (list? l)                   '' Es l una lista?
;; (null? l)                   '' En l una lista vacía?


;; (car '(1 2 3))   -> 1
;; (cdr '(1 2 3))   -> (2 3)
;; (car '())        -> ERROR!
;; (cdr '())        -> ERROR!
;; (car '(1 2))     -> 1
;; (cdr '(1 2))     -> (2)  ... Prop: (number? (cdr '(1 2))) ?  #t | #f ?
;; (car '( (1 2) 3) -> (1 2)
;; (car (cdr '(1 2 3)) -> 2
;; (car (cons 1 '(2 3)) -> 1
;; (append '(1 2) '(3 4)) -> (1 2 3 4)
;; (append 1 '(2 3)) -> ERROR! Ambos argumentos deben ser listas!!!

; -eval :: <poly> x number -> number 
; evalua un polinomio en un punto dado
(define (-eval poly x) (evalExp poly x 0))

; evalExp :: <poly> x number x number -> number
; Evalua un polinomio en un punto dado y con informacion
; de la potencia donde se encuentra.
(define (evalExp poly x exp)
  (if (null? poly) 0
      (let ((coef (car poly)))
        (+ (pot coef exp) (evalExp poly x (+ 1 exp))))))

; pot :: number x number -> number
; Calcula la potencia dado la base y su exponente
(define (pot base exp)
  (if (= exp 0) 1 (* base (pot base (-exp 1)))))

; -nlist : number x number -> list
; retorna la lista que incluye todos los enteros entre dos números
(define (-nlist n1 n2)
  (cond
    ((> n1 n2) '())
    (else (cons n1 (-nlist (+ n1 1) n2)))
    )
  )

;; (-nlist 1 5)

; -reverse :: list -> list
(define (-reverse ls)
  (if (null? ls) '() (append (-reverse (cdr ls)) (list (car ls)))))

;; my-member : atom x list -> boolean
;; pregunta si un elemento pertenece o no a una lista.
(define (my-member atom list)
  (cond
    ((null? list) #f)
    ((eq? (car list) atom) #t)
    (else (my-member atom (cdr list)))
    ))


(my-member 1 '(1 2 3))
(my-member 5 '(1 2 3))
(my-member 5 '(1 2 3 (5)))

;; eq? : Permite determinar si dos objetos en Scheme son el mismo.

; propuesto: escriba my-member-list que solucione (my-member 5 '(1 2 3 (5)))
(define (my-member-list atom list)
  (cond
    ((null? list) #f)
    ((list? (car list))
     (or 
      (my-member-list atom (car list)) ;; Permite 'entrar' en las sublistas
      (my-member-list atom (cdr list))
      )
     )
    ((eq? (car list) atom) #t)
    (else (my-member-list atom (cdr list)))
    )
  )

(my-member-list 5 '(1 2 3 (5)))
(my-member-list 5 '(1 (5 6) 2 ))
(my-member-list 5 '(1 2 (3 4)))