;; The first three lines of this file were inserted by DrScheme. They record metadata
;; about the language level of this file in a form that our tools can easily process.
#reader(lib "reader.ss" "plai" "lang")
(define (create-queue)
  (let ((q-in empty)
        (q-out empty))
    (letrec ((reset (lambda ()
                       (begin 
                         (set! q-in empty)
                         (set! q-out empty))))
              (-empty? (lambda ()
                         (and (empty? q-in) (empty? q-out))))
              (enqueue (lambda (neo)
                         (set! q-in (cons neo q-in))))
              (dequeue (lambda ()
                         (let ((remove-return 
                               (lambda ()
                                   (let ((top (first q-out)))
                                     (begin
                                       (set! q-out (rest q-out))
                                       top)))))
                          (if (empty? q-out)
                             (begin
                               (set! q-out (reverse q-in))
                               (set! q-in empty)
                               (remove-return))
                             (remove-return))))))
             (vector reset -empty? enqueue dequeue))))

(define (queue-get-reset-operation queue) (vector-ref queue 0))
(define (queue-get-empty?-operation queue) (vector-ref queue 1))
(define (queue-get-enqueue-operation queue) (vector-ref queue 2))
(define (queue-get-dequeue-operation queue) (vector-ref queue 3))



;;tests
(define myqueue (create-queue))
(define enqueue-myqueue (queue-get-enqueue-operation myqueue))
(define dequeue-myqueue (queue-get-dequeue-operation myqueue))

(test ((queue-get-empty?-operation myqueue)) #t)
(enqueue-myqueue 1)
(test ((queue-get-empty?-operation myqueue)) #f)
(enqueue-myqueue 2)
(enqueue-myqueue 3)
(test (dequeue-myqueue) 1)
((queue-get-reset-operation myqueue))
(test ((queue-get-empty?-operation myqueue)) #t)