;; The first three lines of this file were inserted by DrScheme.
;; They record information about the language level.
#reader(lib "plai-pretty-big-reader.ss" "plai")((modname pauta-aux3) (read-case-sensitive #t) (teachpacks ()))
;; 1.
;; Queda como propuesta definir sus contratos.
(define zero (lambda(f)(lambda(x) x)))
(define one (lambda(f)(lambda(x)(f x))))
(define two (lambda(f)(lambda(x)(f (f x)))))

;; n cualquiera 
;; n-veces la aplicaci'on de f
;; n = (lambda(f)(lambda(x) (f (f...(f x)))))

;;Sucesor
(define (succ n)
   (lambda (f)
      (lambda (x) (f ((n f) x)))))

;;Adici'on 
(define (add n)
   (lambda (m)
      ((n succ) m)))

;;Producto  
(define (mult n)
   (lambda (m)
      ((n (add m)) zero)))

;;test
(define ++ (lambda (x) (+ 1 x)))

(test ((zero ++) 0) 0)
(test ((one ++) 0) 1)
(test ((two ++) 0) 2)
(define three (succ two))
(test ((three ++) 0) 3)
(define five ((add two) three))
(test ((five ++) 0) 5)
(define fifteen ((mult three) five))
(test ((fifteen ++) 0) 15)
(test ((((mult (succ fifteen)) ((add five) two)) ++) 0) 
      (* (+ 15 1) (+ 5 2)))

;; 2.
(define-type ALE
  (id  (v VAR?))
  (add (l ALE?) (r ALE?))
  (sub (l ALE?) (r ALE?))
)
(define-type VAR
  (var (coef number?) (x symbol?)))

;;parse::S-exp -> ALE
;; Dada una slist, devuelve un valor del tipo ALE, según su estructura.
(define (parse sexp)
  (cond
    ((number? (first sexp)) (id (var (first sexp) (second sexp))))
    ((symbol=? '+ (first sexp)) (add (parse (second sexp)) (parse (third sexp))))
    ((symbol=? '- (first sexp)) (sub (parse (second sexp)) (parse (third sexp))))
    )
  )

;;pp::ALE -> string
;;Dada una exp. en ALE, la convierte en un string con formato pretty. 
(define (pp ale)
  (type-case ALE ale
             (id (x) (ppVar x))
             (add (l r) (string-append "( " (pp l) " + " (pp r) " )"))
             (sub (l r) (string-append "( "(pp l) " - " (pp r) " )"))
             )
  )
;; VAR -> string
;; Función adicional a pp, en este caso para exp del tipo VAR
(define (ppVar var-x)
  (type-case VAR var-x
             (var (c x) (cond 
                          ((= c 1)(symbol->string x))
                          ((= c -1)(string-append "(-" (symbol->string x) ")" ))
                          ((> c 1)(string-append (number->string c) (symbol->string x)))
                          ((< c -1)(string-append "(" (number->string c) (symbol->string x) ")" ))
                          (else "0")
                          )))
  )

;;list->set::List-of-symbol -> List-of-symbol
;; Dado un multiconjunto de caracteres, devuelve su conjunto.
(define (list->set ls)
  (if (empty? ls) '() (cons (first ls) (list->set (remove* (list (first ls)) ls))))
  )

;;x-var:: VAR -> symbol
;; Obtiene el simbolo del VAR
(define (x-var var-x) (type-case VAR var-x (var (c x) x)))
;;c-var:: VAR -> number
;; Obtiene el coef. del VAR
(define (c-var var-x) (type-case VAR var-x (var (c x) c)))


;;simp:: ALE -> ALE
;; Simplifica una exp ale según los coeficientes y simbolos que tenga.
(define (simp ale) (make-simple-ale (list->set (list-var ale)) ale))

;;make-simple-ale::List-of-symbol -> ALE
;; Va simplificando variable (simbolo) por variable.
(define (make-simple-ale ls ale)
 (if (= (length ls) 1) (id (var (calc (car ls) ale) (car ls)))
     (add (id (var (calc (car ls) ale) (car ls))) (make-simple-ale (cdr ls) ale))))

;;calc::symbol, ALE -> number
;; Calcula el coeficiente resultante para cada variable
(define (calc a ale)
  (type-case ALE ale
             (id (x) (if (symbol=? a (x-var x)) (c-var x) 0))
             (add (l r) (+ (calc a l) (calc a r)))             
             (sub (l r) (- (calc a l) (calc a r)))             
             )
  )

;;list-var:: ALE -> List-of-symbol
;; Retorna la lista, en multiconjunto, de los simbolos o variables que tenga
;; una expresión ALE.
(define (list-var ale)
  (type-case ALE ale
             (id (x) (list (x-var x)))
             (add (l r) (append (list-var l) (list-var r)))             
             (sub (l r) (append (list-var l) (list-var r)))             
             )
  )


;;tests
(test (pp (simp (parse '{2 a}))) "2a")
(test (pp (simp (parse '{+ {1 a} {2 a}}))) "3a")
(pp (parse '{+ {- {- {+ {3 a} {1 b}} {1 a}} {2 c}} {+ {-3 c} {2 b}}}))
(test (pp (simp (parse '{+ {- {- {+ {3 a} {1 b}} {1 a}} {2 c}} {+ {-3 c} {2 b}}}))) 
      "( 2a + ( 3b + (-5c) ) )")