;; duple :: Number, A -> <list-of-A>
(define (duple n a)
  (if (= n 0) '() (cons a (duple (- n 1) a))))

;;filter-in:: (Symbol -> Boolean), <list-of-Symbol> -> <list-of-Symbol>
(define (filter-in f ls)
  (cond
    ((null? ls) '())
    ((f (car ls)) (cons (car ls) (filter-in f (cdr ls))))
    (else (filter-in f (cdr ls)) )))

;; duple:: Number, Symbol -> <List-of-Symbol>
(define (duple n x)
  (if (= n 0) '()
      (cons x (duple (- n 1) x))))

;; filter-in::(Symbol->Boolean), <List-of-Symbol> -> <List-of-Symbol>
(define (filter-in p ls)
  (cond
    ((null? ls) '())
    ((p (car ls)) (cons (car ls) (filter-in p (cdr ls))))
    (else (filter-in p (cdr ls)))
    ))

;; BinTree -> ()
;;          | (Sym . BinTree . BinTree)           

;; raiz:: BinTree -> Sym
(define (raiz bt) (car bt))
;; izq:: BinTree -> BinTree
(define (izq bt) (cadr bt))
;; der:: BinTree -> BinTree
(define (der bt) (caddr bt))

;; sum-nodes:: BinTree -> Number
(define sum-nodes
  (lambda (bt)
    (cond
      ((null? bt) 0)
      ((number? (raiz bt)) (+ (raiz bt) (sum-nodes (izq bt)) (sum-nodes (der bt))))
      (else (+ (sum-nodes (izq bt)) (sum-nodes (der bt))))
      )))

;; Seg'un la auxiliar es make-bintree
;; make-bintree-n:: <List-of-Symbols> -> BinTree
(define (make-bintree-n ls)
  (letrec ((make (lambda (lst tree)
                (if (null? lst) tree
                    (make (cdr lst) (make-bintree-1 (car lst) tree)))))) 
    (make ls '())) ;; make:: <List-of-Symbol>, BinTree -> BinTree
  )

;; make-bintree-1:: Symbol, BinTree -> BinTree
(define (make-bintree-1 a bt)
  (cond
    ((null? bt) (list a '() '()))
    ((< a (raiz bt)) (list (raiz bt) (make-bintree-1 a (izq bt)) (der bt)))
    (else (list (raiz bt) (izq bt) (make-bintree-1 a (der bt))))
    ))