import java.awt.*;
import java.awt.event.*;
public class Ascensor extends Frame implements ActionListener {

	protected Panel p;		// Panel que va al centro con los botones
	protected Canvas cv;
	protected Button up, down;
	protected int piso=0;	// Acá guardamos el piso en que estamos
	
	public Ascensor(){
		
		cv = new Canvas();
		cv.setSize(300, 300);
		up = new Button("Subir");
		down = new Button("Bajar");
		up.addActionListener(this);
		down.addActionListener(this);
		this.setLayout(new BorderLayout());
		this.add("Center", cv);
		p = new Panel();
		p.setLayout(new FlowLayout()); //Se podría hacer con un GridLayout de 2x1 pero este se ve mejor
		p.add(down);
		p.add(up);
		this.add("South", p);
		this.setSize(310, 400);
		
	}
	
	public void dibujar(Graphics g, int p){	// Esta función dibuja i pisos
		
		g.setColor(Color.WHITE);			// Dibujamos un rectángulo que blanco cubre 
		g.fillRect(0, 0, 300, 300);			// todo el canvas en otras palabras borrar
		for(int i = 0; i < p; i++){							// Dibujamos p rectángulos de color azul 
			g.setColor(Color.BLUE);								// Cada rectángulo mide 30 de ancho y la altura mide 125 + 30*(nº de piso-1) 
			g.fillRect(40*i+30, 150-30*i+75, 40, 150+30*i-75);	// y se ubica a 40*(nº de piso -1) 30 de el lado izquierdo
		}
	
	}
	
	public void actionPerformed(ActionEvent e){
		
		if(e.getSource() == down){		// Si el usuario apreta bajar disminuimos el piso
			piso = piso-1;
			piso = piso < 0? 0 : piso;	// Para que no pueda ir al piso -1
		}
		else{							// Si el usuario apreta subir aumentamos el piso
			piso = piso+1;
			piso = piso > 6? 6 : piso; 	// Para que no pueda ir al piso 7
		}
		this.dibujar(cv.getGraphics(), piso);	// Dibujamos los rectángulos que representan el piso	
		
	}
	
	static public void main(String []args){
		
		new Ascensor().setVisible(true);
		
	}
	
}
