/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm.remotecontrol;

import java.io.IOException;
import josx.rcxcomm.Tower;
import josx.rcxcomm.TowerException;

public class RemoteControlMessenger {
    public static final byte[] NONE = new byte[]{0, 0};
    public static final byte[] MESSAGE1 = new byte[]{0, 1};
    public static final byte[] MESSAGE2 = new byte[]{0, 2};
    public static final byte[] MESSAGE3 = new byte[]{0, 4};
    public static final byte[] MOTOR_A_UP = new byte[]{0, 8};
    public static final byte[] MOTOR_B_UP = new byte[]{0, 16};
    public static final byte[] MOTOR_C_UP = new byte[]{0, 32};
    public static final byte[] MOTOR_A_DOWN = new byte[]{0, 64};
    public static final byte[] MOTOR_B_DOWN = new byte[]{0, -128};
    public static final byte[] MOTOR_C_DOWN = new byte[]{1, 0};
    public static final byte[] PROGRAM1 = new byte[]{2, 0};
    public static final byte[] PROGRAM2 = new byte[]{4, 0};
    public static final byte[] PROGRAM3 = new byte[]{8, 0};
    public static final byte[] PROGRAM4 = new byte[]{16, 0};
    public static final byte[] PROGRAM5 = new byte[]{32, 0};
    public static final byte[] STOP = new byte[]{64, 0};
    public static final byte[] SOUND = new byte[]{-128, 0};
    private Tower fTower = null;
    private byte[] fPacket = null;

    public RemoteControlMessenger(String port) throws UnsatisfiedLinkError {
        this.fTower = new Tower(port);
        this.fPacket = new byte[3];
        this.fPacket[0] = -46;
    }

    public void send(byte[] aMessageCode) throws IOException {
        if (aMessageCode.length != 2) {
            throw new IOException("invalid message code");
        }
        this.fPacket[1] = aMessageCode[0];
        this.fPacket[2] = aMessageCode[1];
        this.sendPacket(this.fPacket, 3);
    }

    private void sendPacket(byte[] aPacket, int aPacketLength) throws IOException {
        try {
            this.fTower.openTower(false);
            this.fTower.sendPacket(aPacket);
            this.fTower.closeTower();
        }
        catch (TowerException e) {
            IOException ioExc = new IOException(e.getMessage());
            ioExc.fillInStackTrace();
            throw ioExc;
        }
    }
}

