/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import josx.rcxcomm.TowerException;

public class Tower {
    public static final int DEFAULT_READ_TIMEOUT = 100;
    private String _tty;
    private boolean _isOpen;
    private long _port;
    private int _error;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Tower(String tty) {
        if (!$assertionsDisabled && tty == null) {
            throw new AssertionError((Object)"Precondition: tty != null");
        }
        this._tty = tty;
        this._isOpen = false;
    }

    public void openTower(boolean fastMode) throws TowerException {
        int status = this.open(this._tty, fastMode);
        if (status != 0) {
            throw new TowerException(status);
        }
        this._isOpen = true;
    }

    public void closeTower() throws TowerException {
        int status = this.close();
        this._isOpen = false;
        if (status != 0) {
            throw new TowerException(status);
        }
    }

    public int getError() {
        return this._error;
    }

    public void writeBytes(byte[] data) throws TowerException {
        if (!$assertionsDisabled && data == null) {
            throw new AssertionError((Object)"Precondition: data != null");
        }
        int status = this.write(data, data.length);
        if (status < 0) {
            throw new TowerException(status);
        }
    }

    public void sendPacket(byte[] data) throws TowerException {
        if (!$assertionsDisabled && data == null) {
            throw new AssertionError((Object)"Precondition: data != null");
        }
        int status = this.send(data, data.length);
        if (status < 0) {
            throw new TowerException(status);
        }
    }

    public int readBytes(byte[] data) throws TowerException {
        return this.readBytes(data, 100);
    }

    public int readBytes(byte[] data, int timeout) throws TowerException {
        if (!$assertionsDisabled && data == null) {
            throw new AssertionError((Object)"Precondition: data != null");
        }
        if (!$assertionsDisabled && timeout <= 0) {
            throw new AssertionError((Object)"Precondition: timeout > 0");
        }
        int result = this.read(data, timeout);
        if (result < 0) {
            throw new TowerException(result);
        }
        if (!$assertionsDisabled && result < 0) {
            throw new AssertionError((Object)"Postcondition: result >= 0");
        }
        return result;
    }

    public int receivePacket(byte[] data) throws TowerException {
        return this.receivePacket(data, 100);
    }

    public int receivePacket(byte[] data, int timeout) throws TowerException {
        if (!$assertionsDisabled && data == null) {
            throw new AssertionError((Object)"Precondition: data != null");
        }
        if (!$assertionsDisabled && timeout <= 0) {
            throw new AssertionError((Object)"Precondition: timeout > 0");
        }
        int result = this.receive(data, timeout);
        if (result < 0) {
            throw new TowerException(result);
        }
        if (!$assertionsDisabled && result < 0) {
            throw new AssertionError((Object)"Postcondition: result >= 0");
        }
        return result;
    }

    public int sendPacketReceivePacket(byte[] data, byte[] response, int retries) throws TowerException {
        return this.sendPacketReceivePacket(data, response, retries, 100);
    }

    public int sendPacketReceivePacket(byte[] data, byte[] response, int retries, int timeout) throws TowerException {
        TowerException towerException = null;
        int numRead = -1;
        while (retries > 0) {
            towerException = null;
            try {
                this.sendPacket(data);
                numRead = this.receivePacket(response, timeout);
                break;
            }
            catch (TowerException e) {
                towerException = e;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    throw new TowerException("interrupted");
                }
                --retries;
            }
        }
        if (towerException != null) {
            throw towerException;
        }
        if (!$assertionsDisabled && numRead < 0) {
            throw new AssertionError((Object)"Postcondition: numRead >= 0");
        }
        return numRead;
    }

    protected final native int open(String var1, boolean var2);

    protected final native int close();

    public final native boolean isRCXAlive();

    public final native boolean isUSB();

    protected final native int write(byte[] var1, int var2);

    protected final native int send(byte[] var1, int var2);

    protected final native int read(byte[] var1, int var2);

    protected final native int receive(byte[] var1, int var2);

    private static native void init();

    static {
        $assertionsDisabled = !Tower.class.desiredAssertionStatus();
        try {
            System.err.println("Loading native libs");
            System.loadLibrary("jirtrcx");
            Tower.init();
        }
        catch (Throwable e1) {
            System.err.println("Unable to load native libraries: " + e1.getMessage());
        }
    }
}

