/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import josx.rcxcomm.RCXPort;

public class SocketProxy {
    private static DataInputStream dis;
    private static DataOutputStream dos;

    private SocketProxy(String port) {
        try {
            RCXPort rcxport = new RCXPort(port);
            InputStream is = rcxport.getInputStream();
            OutputStream os = rcxport.getOutputStream();
            dis = new DataInputStream(is);
            dos = new DataOutputStream(os);
            is.read();
            this.newSocket();
        }
        catch (IOException ioe) {
            System.out.println("IOException: " + ioe.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("argument tower port (USB, COM1 etc) required!");
            System.err.println("shutting down");
        } else {
            new SocketProxy(args[0]);
        }
    }

    private void newSocket() {
        try {
            int len = dis.readByte();
            char[] hostChars = new char[len];
            for (int i = 0; i < len; ++i) {
                hostChars[i] = (char)dis.readByte();
            }
            String host = new String(hostChars);
            int port = dis.readInt();
            System.out.println("Connecting to host: " + host + ",port: " + port);
            Socket sock = new Socket(host, port);
            dos.writeByte(0);
            dos.flush();
            InputStream in = sock.getInputStream();
            OutputStream out = sock.getOutputStream();
            DataInputStream din = new DataInputStream(in);
            DataOutputStream dout = new DataOutputStream(out);
            new InThread(sock, din, dos);
            new OutThread(sock, dis, dout);
        }
        catch (IOException ioe) {
            System.out.println("IOException: " + ioe.getMessage());
        }
    }

    private class OutThread
    extends Thread {
        private DataOutputStream dout;
        private DataInputStream din;
        private Socket sock;

        public OutThread(Socket sock, DataInputStream dis, DataOutputStream dos) {
            this.din = dis;
            this.dout = dos;
            this.sock = sock;
            this.start();
        }

        public void run() {
            byte in = 0;
            while (true) {
                try {
                    while (true) {
                        if ((in = this.din.readByte()) < 0) {
                            System.out.println("Outthread stopped");
                            this.sock.close();
                            SocketProxy.this.newSocket();
                            return;
                        }
                        System.out.println("Outthread: " + (char)in);
                        this.dout.writeByte(in);
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }
    }

    private class InThread
    extends Thread {
        private DataOutputStream dout;
        private DataInputStream din;
        private Socket sock;

        public InThread(Socket sock, DataInputStream dis, DataOutputStream dos) {
            this.din = dis;
            this.dout = dos;
            this.sock = sock;
            this.start();
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        byte in;
                        if ((in = this.din.readByte()) < 0) {
                            System.out.println("Inthread: Closing Socket");
                            this.sock.close();
                            return;
                        }
                        System.out.println("Inthread: " + (char)in);
                        this.dout.writeByte(in);
                        this.dout.flush();
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }
    }
}

