/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import josx.rcxcomm.RCXPort;

public class RCXBean
implements Serializable {
    private String comPort = null;
    private RCXPort port;
    private InputStream in;
    private OutputStream out;
    private boolean open = false;
    private Object owner = null;
    private static final long serialVersionUID = 3544391413744809527L;

    private void openComPort() throws IOException {
        System.gc();
        if (this.comPort == null) {
            throw new IOException("COM port not defined");
        }
        this.port = new RCXPort(this.comPort);
        this.in = this.port.getInputStream();
        this.out = this.port.getOutputStream();
        this.port.setTimeOut(20000);
        this.open = true;
    }

    public String getComPort() {
        return this.comPort;
    }

    public void setComPort(String value) throws IOException {
        if (!value.equals(this.comPort)) {
            this.close();
            this.comPort = value;
            this.openComPort();
        } else {
            this.openComPort();
        }
    }

    public void sendInt(int v) throws IOException {
        if (!this.open) {
            this.openComPort();
        }
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v >>> 0 & 0xFF);
        this.out.flush();
    }

    public void send(byte b) throws IOException {
        if (!this.open) {
            this.openComPort();
        }
        this.out.write(b);
        this.out.flush();
    }

    public void send(byte[] b) throws IOException {
        if (!this.open) {
            this.openComPort();
        }
        this.out.write(b);
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte receive() throws IOException {
        if (!this.open) {
            this.openComPort();
        }
        try {
            this.port.setListen(true);
            byte by = (byte)this.in.read();
            return by;
        }
        finally {
            this.port.setListen(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveInt() throws IOException {
        if (!this.open) {
            this.openComPort();
        }
        try {
            this.port.setListen(true);
            int ch1 = this.in.read();
            int ch2 = this.in.read();
            int ch3 = this.in.read();
            int ch4 = this.in.read();
            if ((ch1 | ch2 | ch3 | ch4) < 0) {
                throw new IOException("The bytes were negative");
            }
            int n = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
            return n;
        }
        finally {
            this.port.setListen(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] receive(int n) throws IOException {
        if (!this.open) {
            this.openComPort();
        }
        this.port.setListen(true);
        try {
            byte[] b = new byte[n];
            for (int i = 0; i < n; ++i) {
                b[i] = (byte)this.in.read();
            }
            byte[] byArray = b;
            return byArray;
        }
        finally {
            this.port.setListen(false);
        }
    }

    public synchronized void lock(Object o) throws IOException {
        if (this.owner != null) {
            throw new IOException("The RCX is in use");
        }
        this.owner = o;
    }

    public synchronized void free(Object o) {
        if (o == this.owner) {
            this.owner = null;
            this.close();
        }
    }

    public void close() {
        this.open = false;
        if (this.port != null) {
            this.port.close();
        }
    }

    public void finalize() {
        this.close();
    }
}

