/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import josx.rcxcomm.PacketHandler;

public abstract class RCXAbstractPort {
    private boolean portOpen = true;
    private Listener listener;
    private int timeOut = 0;
    private RCXInputStream rcxin;
    private RCXOutputStream rcxout;
    protected PacketHandler packetHandler;
    private byte[] inPacket = new byte[2];

    public RCXAbstractPort(PacketHandler handler) throws IOException {
        this.packetHandler = handler;
        this.rcxin = new RCXInputStream(this);
        this.rcxout = new RCXOutputStream(this.packetHandler);
        this.listener = new Listener();
        this.listener.setDaemon(true);
        this.listener.start();
    }

    public RCXAbstractPort(String port, PacketHandler handler) throws IOException {
        this(handler);
    }

    public void setListen(boolean listen) {
        this.packetHandler.setListen(listen);
    }

    public InputStream getInputStream() {
        this.packetHandler.setListen(true);
        return this.rcxin;
    }

    public OutputStream getOutputStream() {
        return this.rcxout;
    }

    public void reset() {
        this.packetHandler.reset();
    }

    public void close() {
        this.portOpen = false;
        this.packetHandler.close();
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    private class RCXOutputStream
    extends OutputStream {
        private PacketHandler packetHandler;
        private byte[] bytePacket = new byte[1];

        public RCXOutputStream(PacketHandler handler) {
            this.packetHandler = handler;
        }

        public synchronized void write(int b) throws IOException {
            this.bytePacket[0] = (byte)b;
            if (!this.packetHandler.sendPacket(this.bytePacket, 1)) {
                throw new IOException("Failed to Receive Reply");
            }
        }
    }

    private class RCXInputStream
    extends InputStream {
        public static final int bufferSize = 32;
        private byte[] buffer = new byte[32];
        private int current = 0;
        private int last = 0;
        private RCXAbstractPort dataPort;

        public RCXInputStream(RCXAbstractPort port) {
            this.dataPort = port;
        }

        public int available() throws IOException {
            if (this.last < this.current) {
                return 32 - (this.current - this.last);
            }
            return this.last - this.current;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read() throws IOException {
            long time1 = System.currentTimeMillis();
            long timeOut = this.dataPort.getTimeOut();
            while (this.available() == 0) {
                if (timeOut != 0L && System.currentTimeMillis() - time1 > timeOut) {
                    throw new IOException("The read timed out");
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException iE) {}
            }
            byte[] byArray = this.buffer;
            synchronized (this.buffer) {
                int b = this.buffer[this.current++];
                if (this.current == 32) {
                    this.current = 0;
                }
                if (b < 0) {
                    b += 256;
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return b;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(byte b) {
            byte[] byArray = this.buffer;
            synchronized (this.buffer) {
                this.buffer[this.last++] = b;
                if (this.last == 32) {
                    this.last = 0;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    private class Listener
    extends Thread {
        private Listener() {
        }

        public void run() {
            while (RCXAbstractPort.this.portOpen) {
                if (RCXAbstractPort.this.packetHandler.isPacketAvailable()) {
                    int r = RCXAbstractPort.this.packetHandler.receivePacket(RCXAbstractPort.this.inPacket);
                    for (int i = 0; i < r; ++i) {
                        RCXAbstractPort.this.rcxin.add(RCXAbstractPort.this.inPacket[i]);
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

