/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import josx.rcxcomm.LNPHandler;
import josx.rcxcomm.PacketHandler;

public class LNPIntegrityHandler
extends PacketHandler {
    private byte[] inPacket = new byte[259];
    private byte[] outPacket = new byte[259];
    private int inPacketLength = 0;
    private byte op;
    private boolean isAddressing;
    private boolean debug = false;

    public LNPIntegrityHandler(PacketHandler handler, byte op) {
        super(handler);
        this.op = op;
    }

    public boolean isAddressing() {
        return this.isAddressing;
    }

    public void setOp(byte op) {
        this.op = op;
    }

    public boolean sendPacket(byte[] packet, int len) {
        int sum = this.op + len - 1;
        this.outPacket[0] = this.op;
        this.outPacket[1] = (byte)len;
        for (int i = 0; i < len; ++i) {
            sum += packet[i];
            this.outPacket[i + 2] = packet[i];
        }
        this.outPacket[len + 2] = (byte)sum;
        return this.lowerHandler.sendPacket(this.outPacket, len + 3);
    }

    public int receivePacket(byte[] buffer) {
        int temp = this.inPacketLength - 3;
        for (int i = 0; i < temp; ++i) {
            buffer[i] = this.inPacket[i + 2];
        }
        this.inPacketLength = 0;
        return temp;
    }

    public boolean isPacketAvailable() {
        if (this.inPacketLength > 0) {
            return true;
        }
        while (this.lowerHandler.isPacketAvailable()) {
            int len = this.lowerHandler.receivePacket(this.inPacket);
            int sum = -1;
            for (int i = 0; i < len - 1; ++i) {
                sum += this.inPacket[i];
            }
            if ((byte)sum == this.inPacket[len - 1]) {
                this.inPacketLength = len;
                this.isAddressing = ((LNPHandler)this.lowerHandler).isAddressing();
                return true;
            }
            if (!this.debug) continue;
            System.out.println("Checksum error");
        }
        return false;
    }
}

