/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import josx.rcxcomm.PacketHandler;
import josx.rcxcomm.Tower;
import josx.rcxcomm.TowerException;

public class LNPHandler
extends PacketHandler {
    private byte op;
    private Tower tower;
    private boolean gotPacket = false;
    private boolean debug = false;
    private byte[] inPacket = new byte[259];
    private int inPacketLength;
    private int usbFlag;
    private boolean listen = false;
    private byte[] trash = new byte[1];
    private byte[] keepAlive = new byte[]{-1};
    private long sendTime;
    private boolean isAddressing;

    public LNPHandler(String port) {
        try {
            this.tower = new Tower(port);
            this.tower.openTower(false);
            this.usbFlag = this.tower.isUSB() ? 1 : 0;
        }
        catch (TowerException e) {
            e.printStackTrace();
        }
    }

    public boolean isAddressing() {
        return this.isAddressing;
    }

    public int getError() {
        return this.tower.getError();
    }

    public void setListen(boolean listen) {
        this.listen = listen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendPacket(byte[] packet, int len) {
        LNPHandler lNPHandler = this;
        synchronized (lNPHandler) {
            if (this.debug) {
                String s = "Sending packet";
                for (int i = 0; i < len; ++i) {
                    s = s + " " + packet[i];
                }
                System.out.println(s);
            }
            this.sendTime = System.currentTimeMillis();
            boolean r = this.tower.write(packet, len) == len;
            byte[] echo = new byte[len];
            if (this.usbFlag == 0) {
                this.tower.read(echo, 100);
            }
            return r;
        }
    }

    public int receivePacket(byte[] buffer) {
        if (this.debug) {
            String s = "Receiving Packet";
            for (int i = 0; i < this.inPacketLength; ++i) {
                s = s + " " + this.inPacket[i];
            }
            System.out.println(s);
        }
        this.gotPacket = false;
        for (int i = 0; i < this.inPacketLength; ++i) {
            buffer[i] = this.inPacket[i];
        }
        return this.inPacketLength;
    }

    private void getOp() {
        byte[] b;
        int r;
        do {
            if ((r = this.tower.read(b = new byte[1], 100)) <= 0) {
                long currTime;
                if (this.usbFlag == 0 && this.listen && (currTime = System.currentTimeMillis()) - this.sendTime >= 3000L) {
                    if (this.debug) {
                        System.out.println("Sending keep-alive");
                    }
                    this.tower.write(this.keepAlive, 1);
                    this.tower.read(this.trash, 100);
                    this.sendTime = currTime;
                }
                return;
            }
            this.op = b[0];
        } while (this.op != -16 && this.op != -15);
        r = this.tower.read(b, 100);
        if (r <= 0) {
            return;
        }
        this.gotPacket = true;
        this.isAddressing = this.op == -15;
        this.inPacket[0] = this.op;
        int extra = (b[0] & 0xFF) + 1;
        this.inPacket[1] = b[0];
        byte[] rest = new byte[extra];
        r = this.tower.read(rest, 100);
        for (int i = 0; i < r; ++i) {
            this.inPacket[i + 2] = rest[i];
        }
        this.inPacketLength = extra + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPacketAvailable() {
        LNPHandler lNPHandler = this;
        synchronized (lNPHandler) {
            if (this.gotPacket) {
                return true;
            }
            this.getOp();
            return this.gotPacket;
        }
    }

    public void close() {
        this.tower.close();
    }
}

