/*
 * Decompiled with CFR 0.152.
 */
package josx.rcxcomm;

import josx.rcxcomm.AddressingHandler;
import josx.rcxcomm.IntegrityHandler;
import josx.rcxcomm.LNPHandler;
import josx.rcxcomm.LNPIntegrityHandler;

public class LNP
extends Thread {
    private static final int MAX_HANDLERS = 4;
    private static final int MAX_PORTS = 4;
    private static LNPIntegrityHandler packetHandler;
    private static LNP singleton;
    private static byte[] outPacket;
    private static byte[] inPacket;
    private static byte[] buff;
    private static byte machineAddress;
    private static IntegrityHandler[] integrityHandler;
    private static int numIntegrityHandlers;
    private static AddressingHandler[][] addressingHandler;
    private static int[] numAddressingHandlers;

    private LNP(String port) {
        packetHandler = new LNPIntegrityHandler(new LNPHandler(port), -16);
    }

    public static LNP getLNP(String port) {
        if (singleton == null) {
            singleton = new LNP(port);
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addressingWrite(byte[] packet, int len, byte dest, byte source) {
        LNP lNP = singleton;
        synchronized (lNP) {
            packetHandler.setOp((byte)-15);
            LNP.outPacket[0] = dest;
            LNP.outPacket[1] = source;
            for (int i = 0; i < len; ++i) {
                LNP.outPacket[i + 2] = packet[i];
            }
            return packetHandler.sendPacket(outPacket, len + 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean integrityWrite(byte[] packet, int len) {
        LNP lNP = singleton;
        synchronized (lNP) {
            packetHandler.setOp((byte)-16);
            return packetHandler.sendPacket(packet, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIntegrityHandler(IntegrityHandler handler) {
        LNP lNP = singleton;
        synchronized (lNP) {
            LNP.integrityHandler[LNP.numIntegrityHandlers++] = handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAddressingHandler(AddressingHandler handler, byte port) {
        LNP lNP = singleton;
        synchronized (lNP) {
            byte by = port;
            int n = numAddressingHandlers[by];
            numAddressingHandlers[by] = n + 1;
            LNP.addressingHandler[port][n] = handler;
        }
    }

    public static void startListening(byte addr) {
        machineAddress = addr;
        singleton.setDaemon(true);
        singleton.start();
        packetHandler.setListen(true);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block2: while (true) {
            if (!LNP.packetHandler.isPacketAvailable()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {}
                continue;
            }
            len = LNP.packetHandler.receivePacket(LNP.inPacket);
            if (!LNP.packetHandler.isAddressing()) {
                i = 0;
                while (true) {
                    if (i >= LNP.numIntegrityHandlers) continue block2;
                    LNP.integrityHandler[i].processIntegrityPacket(LNP.inPacket, len);
                    ++i;
                }
            }
            if ((byte)(LNP.inPacket[0] & 240) != LNP.machineAddress) continue;
            for (i = 2; i < len; ++i) {
                LNP.buff[i - 2] = LNP.inPacket[i];
            }
            port = (byte)(LNP.inPacket[0] & 15);
            i = 0;
            while (true) {
                if (i < LNP.numAddressingHandlers[port]) ** break;
                continue block2;
                LNP.addressingHandler[port][i].processAddressingPacket(LNP.buff, len - 2, LNP.inPacket[1]);
                ++i;
            }
            break;
        }
    }

    static {
        outPacket = new byte[64];
        inPacket = new byte[64];
        buff = new byte[64];
        integrityHandler = new IntegrityHandler[4];
        numIntegrityHandlers = 0;
        addressingHandler = new AddressingHandler[4][4];
        numAddressingHandlers = new int[4];
    }
}

